/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.craftingstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingRequest;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationContainer;
import mcjty.rftoolscontrol.blocks.craftingstation.GuiCraftingStation;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_GETCRAFTABLE = "getCraftable";
    public static final String CLIENTCMD_GETCRAFTABLE = "getCraftable";
    public static final String CMD_GETREQUESTS = "getRequests";
    public static final String CLIENTCMD_GETREQUESTS = "getRequests";
    public static final String CMD_REQUEST = "station.request";
    public static final Key<String> PARAM_ITEMNAME = new Key("itemname", Type.STRING);
    public static final Key<Integer> PARAM_META = new Key("meta", Type.INTEGER);
    public static final Key<String> PARAM_NBT = new Key("nbt", Type.STRING);
    public static final Key<Integer> PARAM_AMOUNT = new Key("amount", Type.INTEGER);
    public static final String CMD_CANCEL = "station.cancel";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CraftingStationContainer.factory, 9);
    private List<BlockPos> processorList = new ArrayList<BlockPos>();
    private int currentTicket = 0;
    private List<CraftingRequest> activeCraftingRequests = new ArrayList<CraftingRequest>();
    private int cleanupCounter = 50;

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void registerProcessor(BlockPos pos) {
        if (!this.processorList.contains(pos)) {
            this.processorList.add(pos);
        }
        this.func_70296_d();
    }

    public ItemStack getCraftResult(String craftId) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!craftId.equals(request.getTicket())) continue;
            return request.getStack();
        }
        return ItemStack.field_190927_a;
    }

    private Pair<ProcessorTileEntity, ItemStack> findCraftableItem(int index) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (index == 0) {
                    return Pair.of((Object)processor, (Object)item);
                }
                --index;
            }
        }
        return null;
    }

    public ItemStack craftOk(ProcessorTileEntity processor, String ticket, ItemStack stack) {
        CraftingRequest foundRequest = null;
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            foundRequest = request;
            break;
        }
        if (foundRequest != null) {
            this.func_70296_d();
            foundRequest.decrTodo();
            if (foundRequest.getTodo() <= 0) {
                foundRequest.setOk(System.currentTimeMillis() + 1000L);
            } else {
                processor.fireCraftEvent(ticket, foundRequest.getStack());
            }
            if (!stack.func_190926_b()) {
                Inventory inventory = this.getInventoryFromTicket(ticket);
                if (inventory != null) {
                    IItemHandler handlerAt = processor.getItemHandlerAt(inventory);
                    if (handlerAt == null) {
                        throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
                    }
                    return ItemHandlerHelper.insertItem((IItemHandler)handlerAt, (ItemStack)stack, (boolean)false);
                }
                return ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (ItemStack)stack, (boolean)false);
            }
        }
        return stack;
    }

    public void craftFail(String ticket) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            request.setFailed(System.currentTimeMillis() + 2000L);
            this.func_70296_d();
        }
    }

    private void cancelCraft(int index) {
        try {
            this.activeCraftingRequests.remove(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCraft(int index, int amount) {
        Pair<ProcessorTileEntity, ItemStack> pair = this.findCraftableItem(index);
        if (pair == null) {
            System.out.println("What? Can't happen");
            return;
        }
        String ticket = this.getNewTicket(null);
        ItemStack stack = (ItemStack)pair.getValue();
        int count = (amount + stack.func_190916_E() - 1) / stack.func_190916_E();
        CraftingRequest request = new CraftingRequest(ticket, stack, count);
        if (!this.checkRequestAmount()) {
            return;
        }
        this.activeCraftingRequests.add(request);
        ((ProcessorTileEntity)pair.getKey()).fireCraftEvent(ticket, stack);
        --this.cleanupCounter;
        if (this.cleanupCounter <= 0) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
        }
    }

    private boolean checkRequestAmount() {
        if (this.activeCraftingRequests.size() >= GeneralConfiguration.maxCraftRequests) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
            if (this.activeCraftingRequests.size() >= GeneralConfiguration.maxCraftRequests) {
                return false;
            }
        }
        return true;
    }

    public boolean isRequested(ItemStack item) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L || ok != -1L || !request.getStack().func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public boolean request(ItemStack item, @Nullable Inventory destination) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack i : items) {
                if (!item.func_77969_a(i)) continue;
                String ticket = this.getNewTicket(destination);
                if (!this.checkRequestAmount()) {
                    return false;
                }
                this.activeCraftingRequests.add(new CraftingRequest(ticket, i, 1));
                processor.fireCraftEvent(ticket, i);
                return true;
            }
        }
        return false;
    }

    private String getNewTicket(@Nullable Inventory destInv) {
        ++this.currentTicket;
        this.func_70296_d();
        if (destInv != null) {
            return destInv.serialize() + "#" + this.currentTicket;
        }
        return BlockPosTools.toString((BlockPos)this.field_174879_c) + ":" + this.currentTicket;
    }

    @Nullable
    private Inventory getInventoryFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return Inventory.deserialize(ticket);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return null;
        }
        String[] splitted = StringUtils.split((String)ticket, (char)';');
        String[] poss = StringUtils.split((String)splitted[0], (char)',');
        return new BlockPos(Integer.parseInt(poss[0]), Integer.parseInt(poss[1]), Integer.parseInt(poss[2]));
    }

    public ItemStackList getCraftableItems() {
        ItemStackList items = ItemStackList.create();
        for (BlockPos p : this.processorList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.getCraftableItems((List<ItemStack>)items);
        }
        return items;
    }

    private void cleanupStaleRequests() {
        long time = System.currentTimeMillis();
        List<CraftingRequest> oldRequests = this.activeCraftingRequests;
        this.activeCraftingRequests = new ArrayList<CraftingRequest>();
        for (CraftingRequest request : oldRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L && time > failed || ok != -1L && time > ok) continue;
            this.activeCraftingRequests.add(request);
        }
    }

    public List<CraftingRequest> getRequests() {
        this.cleanupStaleRequests();
        return new ArrayList<CraftingRequest>(this.activeCraftingRequests);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readProcessorList(tagCompound);
        this.readRequests(tagCompound);
    }

    private void readRequests(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c("requests", 10);
        this.activeCraftingRequests.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound requestTag = list.func_150305_b(i);
            String craftId = requestTag.func_74779_i("craftId");
            ItemStack stack = new ItemStack(requestTag.func_74775_l("stack"));
            int count = requestTag.func_74762_e("count");
            CraftingRequest request = new CraftingRequest(craftId, stack, count);
            request.setFailed(requestTag.func_74763_f("failed"));
            request.setOk(requestTag.func_74763_f("ok"));
            this.activeCraftingRequests.add(request);
        }
    }

    private void readProcessorList(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c("processors", 10);
        this.processorList.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.processorList.add(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeProcessorList(tagCompound);
        this.writeRequests(tagCompound);
        return tagCompound;
    }

    private void writeRequests(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (CraftingRequest request : this.activeCraftingRequests) {
            NBTTagCompound requestTag = new NBTTagCompound();
            requestTag.func_74778_a("craftId", request.getTicket());
            NBTTagCompound stackNbt = new NBTTagCompound();
            request.getStack().func_77955_b(stackNbt);
            requestTag.func_74782_a("stack", (NBTBase)stackNbt);
            requestTag.func_74768_a("count", request.getTodo());
            requestTag.func_74772_a("failed", request.getFailed());
            requestTag.func_74772_a("ok", request.getOk());
            list.func_74742_a((NBTBase)requestTag);
        }
        tagCompound.func_74782_a("requests", (NBTBase)list);
    }

    private void writeProcessorList(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (BlockPos p : this.processorList) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", p.func_177958_n());
            tag.func_74768_a("y", p.func_177956_o());
            tag.func_74768_a("z", p.func_177952_p());
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("processors", (NBTBase)list);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.currentTicket = tagCompound.func_74762_e("craftId");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("craftId", this.currentTicket);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    private int findItem(String itemName, int meta, String nbtString) {
        int index = 0;
        for (BlockPos p : this.processorList) {
            TileEntity te = this.func_145831_w().func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (item.func_77952_i() == meta && itemName.equals(item.func_77973_b().getRegistryName().toString())) {
                    if (item.func_77942_o()) {
                        if (nbtString.equalsIgnoreCase(item.serializeNBT().toString())) {
                            return index;
                        }
                    } else {
                        return index;
                    }
                }
                ++index;
            }
        }
        return -1;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_REQUEST.equals(command)) {
            String nbtString;
            int meta;
            String itemName = (String)params.get(PARAM_ITEMNAME);
            int index = this.findItem(itemName, meta = ((Integer)params.get(PARAM_META)).intValue(), nbtString = (String)params.get(PARAM_NBT));
            if (index == -1) {
                return true;
            }
            int amount = (Integer)params.get(PARAM_AMOUNT);
            this.startCraft(index, amount);
            return true;
        }
        if (CMD_CANCEL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            this.cancelCraft(index);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getCraftable".equals(command)) {
            return type.convert((List)this.getCraftableItems());
        }
        if ("getRequests".equals(command)) {
            return type.convert(this.getRequests());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getCraftable".equals(command)) {
            GuiCraftingStation.storeCraftableForClient(Type.create(ItemStack.class).convert(list));
            return true;
        }
        if ("getRequests".equals(command)) {
            GuiCraftingStation.storeRequestsForClient(Type.create(CraftingRequest.class).convert(list));
            return true;
        }
        return false;
    }
}

