/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.multiblock;

import ipsis.woot.util.StringHelper;

public enum EnumMobFactoryTier {
    TIER_ONE,
    TIER_TWO,
    TIER_THREE,
    TIER_FOUR;

    public static final EnumMobFactoryTier[] VALID_TIERS;

    public String getTranslated(String format) {
        return String.format(StringHelper.localize(format), this == TIER_ONE ? "I" : (this == TIER_TWO ? "II" : (this == TIER_THREE ? "III" : "IV")));
    }

    public int getLevel() {
        return this.ordinal() + 1;
    }

    public EnumMobFactoryTier getNext() {
        int next = this.ordinal();
        if (++next < 0 || next >= VALID_TIERS.length) {
            next = 0;
        }
        return VALID_TIERS[next];
    }

    public static EnumMobFactoryTier getTier(int v) {
        if (v < 0 || v > EnumMobFactoryTier.values().length - 1) {
            v = 0;
        }
        return EnumMobFactoryTier.values()[v];
    }

    public static boolean isLessThanOrEqual(EnumMobFactoryTier a, EnumMobFactoryTier b) {
        return a.ordinal() <= b.ordinal();
    }

    static {
        VALID_TIERS = new EnumMobFactoryTier[]{TIER_ONE, TIER_TWO, TIER_THREE, TIER_FOUR};
    }
}

