/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.network.PacketGhostSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public abstract class GhostSlot {
    @Nullable
    private TileEntityBase te = null;
    private int slot = -1;
    private int x;
    private int y;
    private boolean visible = true;
    private boolean grayOut = true;
    private float grayOutLevel = 0.5f;
    private boolean displayStdOverlay = false;
    private int stackSizeLimit = 1;
    private boolean updateServer = false;

    public boolean isMouseOver(int mx, int my) {
        return mx >= this.getX() && mx < this.getX() + 16 && my >= this.getY() && my < this.getY() + 16;
    }

    @Nonnull
    public abstract ItemStack getStack();

    public void putStack(@Nonnull ItemStack stack, int realsize) {
        if (this.shouldUpdateServer()) {
            EnderPacketHandler.sendToServer(PacketGhostSlot.setGhostSlotContents(this.getSlot(), stack, realsize));
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean shouldGrayOut() {
        return this.grayOut;
    }

    public void setGrayOut(boolean grayOut) {
        this.grayOut = grayOut;
    }

    public float getGrayOutLevel() {
        return this.grayOutLevel;
    }

    public void setGrayOutLevel(float grayOutLevel) {
        this.grayOutLevel = grayOutLevel;
    }

    public boolean shouldDisplayStdOverlay() {
        return this.displayStdOverlay;
    }

    public void setDisplayStdOverlay(boolean displayStdOverlay) {
        this.displayStdOverlay = displayStdOverlay;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public boolean shouldUpdateServer() {
        return this.updateServer;
    }

    public void setUpdateServer(boolean updateServer) {
        this.updateServer = updateServer;
    }

    public TileEntityBase getTe() {
        return this.te;
    }

    public void setTe(TileEntityBase te) {
        this.te = te;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public static interface IGhostSlotAware {
        public void setGhostSlotContents(int var1, @Nonnull ItemStack var2, int var3);
    }
}

