/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import com.mojang.authlib.GameProfile;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTHelper {
    public static <T extends NBTBase> Collector<T, ?, NBTTagList> toNBTTagList() {
        return Collector.of(NBTTagList::new, NBTTagList::func_74742_a, (nbtBases, nbtBases2) -> {
            for (int i = 0; i < nbtBases2.func_74745_c(); ++i) {
                nbtBases.func_74742_a(nbtBases2.func_179238_g(i));
            }
            return nbtBases;
        }, new Collector.Characteristics[0]);
    }

    public static <K, V, KT extends NBTBase, VT extends NBTBase> void deserializeListIntoMap(@Nonnull Map<K, V> map, @Nonnull NBTTagList list, @Nonnull String keyName, @Nonnull String valName, @Nonnull Function<KT, K> nbtToKey, @Nonnull Function<VT, V> nbtToVal) {
        map.clear();
        NBTHelper.wrapList(list).forEach(t -> {
            if (t.func_74764_b(keyName) && t.func_74764_b(valName)) {
                Object key = nbtToKey.apply(t.func_74781_a(keyName));
                Object value = nbtToVal.apply(t.func_74781_a(valName));
                map.put(key, value);
            }
        });
    }

    public static <K, V> NBTTagList serializeMapToList(@Nonnull Map<K, V> map, @Nonnull String keyName, @Nonnull String valName, @Nonnull Function<K, ? extends NBTBase> keyToNBT, @Nonnull Function<V, ? extends NBTBase> valToNBT) {
        return map.entrySet().stream().map(e -> NBTHelper.builder().setTag(keyName, (NBTBase)keyToNBT.apply(e.getKey())).setTag(valName, (NBTBase)valToNBT.apply(e.getValue())).build()).collect(NBTHelper.toNBTTagList());
    }

    @Nullable
    public static <T extends NBTBase> List<T> wrapList(final @Nonnull NBTTagList list) {
        return new AbstractList<T>(){

            @Override
            public int size() {
                return list.func_74745_c();
            }

            @Override
            @Nullable
            public T get(int index) {
                NBTBase nbtBase = list.func_179238_g(index);
                if (nbtBase.func_74732_a() != list.func_150303_d()) {
                    return null;
                }
                return nbtBase;
            }
        };
    }

    @Nonnull
    public static NBTChainBuilder builder() {
        return new NBTChainBuilder(new NBTTagCompound());
    }

    @Nonnull
    public static GameProfile profileFromNBT(@Nonnull NBTTagCompound tag) {
        return new GameProfile(new UUID(tag.func_74763_f("upper"), tag.func_74763_f("lower")), tag.func_74779_i("name"));
    }

    public static NBTTagCompound profileToNBT(@Nonnull GameProfile profile) {
        return NBTHelper.builder().setLong("lower", profile.getId().getLeastSignificantBits()).setLong("upper", profile.getId().getMostSignificantBits()).setString("name", profile.getName()).build();
    }

    public static <NBT extends NBTBase, T extends INBTSerializable<NBT>> Function<NBT, T> deserializer(@Nonnull Supplier<T> blank) {
        return tag -> {
            INBTSerializable t = (INBTSerializable)blank.get();
            t.deserializeNBT(tag);
            return t;
        };
    }

    public static class NBTChainBuilder {
        final NBTTagCompound tag;

        public NBTTagCompound build() {
            return this.tag;
        }

        public NBTChainBuilder() {
            this(new NBTTagCompound());
        }

        public NBTChainBuilder(NBTTagCompound tag) {
            this.tag = tag;
        }

        @Nonnull
        public NBTChainBuilder setTag(@Nonnull String key, @Nonnull NBTBase value) {
            this.tag.func_74782_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setByte(@Nonnull String key, byte value) {
            this.tag.func_74774_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setShort(@Nonnull String key, short value) {
            this.tag.func_74777_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setInteger(@Nonnull String key, int value) {
            this.tag.func_74768_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setLong(@Nonnull String key, long value) {
            this.tag.func_74772_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setUniqueId(String key, @Nonnull UUID value) {
            this.tag.func_186854_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setFloat(@Nonnull String key, float value) {
            this.tag.func_74776_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setDouble(@Nonnull String key, double value) {
            this.tag.func_74780_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setString(@Nonnull String key, @Nonnull String value) {
            this.tag.func_74778_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setByteArray(@Nonnull String key, @Nonnull byte[] value) {
            this.tag.func_74773_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setIntArray(@Nonnull String key, @Nonnull int[] value) {
            this.tag.func_74783_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder setBoolean(@Nonnull String key, boolean value) {
            this.tag.func_74757_a(key, value);
            return this;
        }

        @Nonnull
        public NBTChainBuilder merge(@Nonnull NBTTagCompound other) {
            this.tag.func_179237_a(other);
            return this;
        }
    }
}

