/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile;

import epicsquid.mysticallib.MysticalLib;
import epicsquid.mysticallib.gui.GuiHandler;
import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.tile.module.FaceConfig;
import epicsquid.mysticallib.tile.module.IModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileModular
extends TileBase {
    @Nonnull
    private List<IModule> modules = new ArrayList<IModule>();
    @Nonnull
    private FaceConfig faceConfig = new FaceConfig(FaceConfig.FaceIO.NEUTRAL);

    public TileModular(IModule ... modules) {
        if (modules != null) {
            Collections.addAll(this.modules, modules);
        }
    }

    public TileModular() {
        this(null);
    }

    public TileModular addModule(@Nonnull IModule module) {
        this.modules.add(module);
        return this;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (IModule m : this.modules) {
            tag.func_74782_a(m.getModuleName(), (NBTBase)m.writeToNBT());
        }
        tag.func_74782_a("faceConfig", (NBTBase)this.faceConfig.writeToNBT());
        return tag;
    }

    public void func_145839_a(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (IModule m : this.modules) {
            if (!tag.func_74764_b(m.getModuleName())) continue;
            m.readFromNBT(tag.func_74775_l(m.getModuleName()));
        }
        this.faceConfig.readFromNBT(tag.func_74775_l("faceConfig"));
    }

    public boolean hasCapability(@Nonnull Capability capability, @Nullable EnumFacing facing) {
        for (IModule m : this.modules) {
            if (!m.hasCapability(capability, facing)) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        for (IModule m : this.modules) {
            if (!m.hasCapability(capability, facing)) continue;
            return m.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasGui() && GuiHandler.hasGui(TileModular.getTileName(this.getClass()))) {
            player.openGui((Object)MysticalLib.INSTANCE, GuiHandler.getGuiID(TileModular.getTileName(this.getClass())), world, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        for (IModule m : this.modules) {
            m.onBroken(world, pos, player);
        }
        super.breakBlock(world, pos, state, player);
    }

    protected boolean hasGui() {
        return false;
    }

    @Nonnull
    public FaceConfig getFaceConfig() {
        return this.faceConfig;
    }
}

