/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.handlers;

import epicsquid.mysticallib.handlers.SmartTank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MysticalFluidHandler
implements IFluidHandler {
    @Nonnull
    private List<SmartTank> tanks = new ArrayList<SmartTank>();
    private int maxInsert;
    private int maxExtract;

    public MysticalFluidHandler(int maxTransfer) {
        this(maxTransfer, null);
    }

    public MysticalFluidHandler(int maxTransfer, SmartTank ... tanks) {
        this(maxTransfer, maxTransfer, tanks);
    }

    public MysticalFluidHandler(int maxInsert, int maxExtract, SmartTank ... tanks) {
        if (tanks != null) {
            Collections.addAll(this.tanks, tanks);
        }
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    public MysticalFluidHandler addTank(@Nonnull SmartTank tank) {
        this.tanks.add(tank);
        return this;
    }

    @Nonnull
    public IFluidTankProperties[] getTankProperties() {
        ArrayList<IFluidTankProperties> props = new ArrayList<IFluidTankProperties>();
        for (SmartTank t : this.tanks) {
            IFluidTankProperties[] tprops;
            for (IFluidTankProperties p : tprops = t.getTankProperties()) {
                props.add(p);
            }
        }
        return props.toArray(new IFluidTankProperties[props.size()]);
    }

    public int fill(@Nullable FluidStack resource, boolean doFill) {
        for (SmartTank t : this.tanks) {
            if (!t.canFill(resource)) continue;
            return t.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
        for (SmartTank t : this.tanks) {
            if (!t.canDrain(resource)) continue;
            return t.drain(resource, doDrain);
        }
        return new FluidStack(resource.getFluid(), 0);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        Iterator<SmartTank> iterator = this.tanks.iterator();
        if (iterator.hasNext()) {
            SmartTank t = iterator.next();
            return t.drain(maxDrain, doDrain);
        }
        return null;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getMaxInsert() {
        return this.maxInsert;
    }

    @Nonnull
    public List<SmartTank> getTanks() {
        return this.tanks;
    }

    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        NBTTagCompound tankList = new NBTTagCompound();
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).writeCommon("tank" + i, tag);
        }
        tag.func_74782_a("tanks", (NBTBase)tankList);
    }

    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b("tanks")) {
            NBTTagCompound tankList = tag.func_74775_l("tanks");
            for (int i = 0; i < this.tanks.size(); ++i) {
                this.tanks.get(i).readCommon("tank" + i, tankList);
            }
        }
    }
}

