/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.variablecontainer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class VariableContainerDefault
implements IVariableContainer {
    private final Map<Integer, IVariableFacade> variableCache = Maps.newHashMap();

    @Override
    public Map<Integer, IVariableFacade> getVariableCache() {
        return this.variableCache;
    }

    @Override
    public void refreshVariables(INetwork network, IInventory inventory, boolean sendVariablesUpdateEvent) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
        if (partNetwork != null) {
            for (IVariableFacade variableFacade : this.getVariableCache().values()) {
                IVariable variable = variableFacade.getVariable(partNetwork);
                if (variable == null) continue;
                variable.invalidate();
            }
        }
        this.getVariableCache().clear();
        IVariableFacade firstInvalidVariableFacade = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            IVariableFacade variableFacade;
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || (variableFacade = ItemVariable.getInstance().getVariableFacade(itemStack)) == null) continue;
            if (variableFacade.isValid()) {
                this.getVariableCache().put(variableFacade.getId(), variableFacade);
                continue;
            }
            if (firstInvalidVariableFacade != null) continue;
            firstInvalidVariableFacade = variableFacade;
        }
        if (this.getVariableCache().isEmpty() && firstInvalidVariableFacade != null) {
            this.getVariableCache().put(firstInvalidVariableFacade.getId(), firstInvalidVariableFacade);
        }
        if (sendVariablesUpdateEvent && network != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }
}

