/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import magicbees.api.ITransmutationController;
import magicbees.api.ITransmutationHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class DefaultTransmutationController
implements ITransmutationController {
    private final Set<ITransmutationHandler> transmutationHandlers = Sets.newHashSet();

    public DefaultTransmutationController(ITransmutationHandler ... handlers) {
        if (handlers != null) {
            for (ITransmutationHandler handler : handlers) {
                this.addTransmutationHandler(handler);
            }
        }
    }

    @Override
    public boolean addTransmutationHandler(ITransmutationHandler transmutationHandler) {
        return this.transmutationHandlers.add((ITransmutationHandler)Preconditions.checkNotNull((Object)transmutationHandler));
    }

    @Override
    public boolean transmute(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            IBlockState state = world.func_180495_p(pos);
            ItemStack source = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            if (source.func_190926_b()) {
                return false;
            }
            Biome biome = world.func_180494_b(pos);
            for (ITransmutationHandler transmutationHandler : this.transmutationHandlers) {
                if (!transmutationHandler.transmute(world, pos, source, biome)) continue;
                return true;
            }
        }
        return false;
    }
}

