/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.integration.aelib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import org.softc.armoryexpansion.integration.aelib.Config;
import org.softc.armoryexpansion.integration.aelib.IIntegration;
import org.softc.armoryexpansion.integration.plugins.tinkers_construct.TiCMaterial;

public abstract class AbstractIntegration
implements IIntegration {
    protected Logger logger;
    private Config configHelper;
    private Map<String, TiCMaterial> materials = new HashMap<String, TiCMaterial>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.configHelper = new Config(new Configuration(event.getSuggestedConfigurationFile()));
        this.setMaterials(event);
        this.configHelper.syncConfig(this.materials);
        this.registerMaterials();
        this.registerMaterialStats();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.oredictMaterials();
        this.updateMaterials();
        this.registerMaterialTraits();
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
    }

    @Override
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
    }

    public Configuration getConfiguration() {
        return this.configHelper.getConfiguration();
    }

    protected Config getConfigHelper() {
        return this.configHelper;
    }

    protected void addMaterial(TiCMaterial material) {
        if (this.isMaterialEnabled(material)) {
            this.materials.putIfAbsent(material.getIdentifier(), material);
        }
    }

    protected void setMaterials(FMLPreInitializationEvent event) {
        this.loadMaterialsFromJson(event.getModConfigurationDirectory(), event.getModMetadata().modId);
        this.loadMaterialsFromSource();
        this.saveMaterialsToJson(event.getModConfigurationDirectory(), event.getModMetadata().modId);
    }

    protected abstract void loadMaterialsFromSource();

    protected void loadMaterialsFromJson(File configDir, String root, String modid) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        Gson gson = builder.create();
        TiCMaterial[] jsonMaterials = new TiCMaterial[]{};
        try {
            File input = new File(configDir.getPath() + "\\" + root + "\\" + modid + ".json");
            jsonMaterials = (TiCMaterial[])gson.fromJson((Reader)new FileReader(input), TiCMaterial[].class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (TiCMaterial m : jsonMaterials) {
            this.materials.put(m.getIdentifier(), m);
        }
    }

    private void loadMaterialsFromJson(File configDir, String modid) {
        this.loadMaterialsFromJson(configDir, "armoryexpansion", modid);
    }

    protected void saveMaterialsToJson(File configDir, String root, String modid) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        Gson gson = builder.create();
        if (configDir.exists()) {
            File output = new File(configDir.getPath() + "\\" + root + "\\" + modid + ".json");
            output.getParentFile().mkdirs();
            try {
                FileWriter writer = new FileWriter(output);
                writer.write(gson.toJson(this.materials.values()));
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveMaterialsToJson(File configDir, String modid) {
        this.saveMaterialsToJson(configDir, "armoryexpansion", modid);
    }

    private void oredictMaterials() {
        this.materials.values().forEach(m -> m.registerOreDict());
    }

    private void registerMaterials() {
        this.materials.values().forEach(m -> {
            if (this.isMaterialEnabled((TiCMaterial)m)) {
                m.registerTinkersMaterial();
            }
        });
    }

    private void registerMaterialStats() {
        this.materials.values().forEach(m -> {
            if (this.isMaterialEnabled((TiCMaterial)m)) {
                m.registerTinkersMaterialStats(this.getProperties((TiCMaterial)m));
            }
        });
    }

    private void updateMaterials() {
        this.materials.values().forEach(m -> {
            if (this.isMaterialEnabled((TiCMaterial)m)) {
                m.updateTinkersMaterial();
            }
        });
    }

    private void registerMaterialTraits() {
        this.materials.values().forEach(m -> {
            if (this.isMaterialEnabled((TiCMaterial)m)) {
                m.registerTinkersMaterialTraits();
            }
        });
    }

    private Map<String, Property> getProperties(TiCMaterial material) {
        return this.getConfigHelper().getProperties(material.getIdentifier());
    }

    private Property getProperty(TiCMaterial material, String property) {
        Map<String, Property> properties = this.getProperties(material);
        if (properties != null && properties.containsKey(property)) {
            return this.getProperties(material).get(property);
        }
        return null;
    }

    public boolean isEnabled(TiCMaterial material, String property) {
        return this.getProperty(material, property).getBoolean();
    }

    private boolean isMaterialEnabled(TiCMaterial material) {
        Property property = this.getProperty(material, "material");
        if (property != null) {
            return this.getProperty(material, "material").getBoolean();
        }
        return true;
    }
}

