/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod;

import aroma1997.core.coremod.CoreMod;
import aroma1997.core.log.LogHelperPre;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class MCPNames {
    private static final Map<String, String> fields = new HashMap<String, String>();
    private static final Map<String, String> methods = new HashMap<String, String>();

    private static void setupMappings(Map<String, ? extends Map<String, String>> sourceMap, Map<String, String> target) {
        while (true) {
            try {
                for (Map.Entry<String, ? extends Map<String, String>> val : sourceMap.entrySet()) {
                    Map<String, String> singles = val.getValue();
                    for (Map.Entry<String, String> e : singles.entrySet()) {
                        String deobfName;
                        String key;
                        String obfName = e.getKey();
                        if (obfName.endsWith(":null")) {
                            key = obfName.substring(0, obfName.length() - ":null".length());
                        } else {
                            if (!obfName.contains("(")) continue;
                            key = obfName.substring(0, obfName.indexOf(40));
                        }
                        if (key.equals(deobfName = e.getValue())) continue;
                        target.put(key, deobfName);
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                LogHelperPre.log(Level.INFO, "Failed to load MCPMappings from forge. Forge probably modified them while we did this. Retrying...");
                LogHelperPre.log(Level.INFO, "Successfully loaded MCPMappings.");
                continue;
            }
            break;
        }
    }

    public static boolean mcp() {
        return !CoreMod.runtimeDeobfuscationEnabled;
    }

    public static String field(String srgName) {
        if (MCPNames.mcp() && fields.containsKey(srgName)) {
            return fields.get(srgName);
        }
        return srgName;
    }

    public static String method(String srgName) {
        if (MCPNames.mcp() && methods.containsKey(srgName)) {
            return methods.get(srgName);
        }
        return srgName;
    }

    static {
        if (MCPNames.mcp()) {
            long time = System.currentTimeMillis();
            LogHelperPre.log(Level.TRACE, "Loading MCP mappings from forge.");
            Map fieldMap = (Map)ReflectionHelper.getPrivateValue(FMLDeobfuscatingRemapper.class, (Object)FMLDeobfuscatingRemapper.INSTANCE, (String[])new String[]{"rawFieldMaps"});
            Map methodMap = (Map)ReflectionHelper.getPrivateValue(FMLDeobfuscatingRemapper.class, (Object)FMLDeobfuscatingRemapper.INSTANCE, (String[])new String[]{"rawMethodMaps"});
            MCPNames.setupMappings(fieldMap, fields);
            MCPNames.setupMappings(methodMap, methods);
            LogHelperPre.log(Level.TRACE, "Finished loading MCP mappings in " + (System.currentTimeMillis() - time) + " ms");
        }
    }
}

