/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.network.message;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.roots.particle.ParticleUtil;
import teamroots.roots.spell.SpellBase;
import teamroots.roots.spell.SpellRegistry;

public class MessageImbueCompleteFX
implements IMessage {
    public static Random random = new Random();
    double posX = 0.0;
    double posY = 0.0;
    double posZ = 0.0;
    String spellName = "null";

    public MessageImbueCompleteFX() {
    }

    public MessageImbueCompleteFX(String name, double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.spellName = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.spellName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.spellName);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    implements IMessageHandler<MessageImbueCompleteFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageImbueCompleteFX message, MessageContext ctx) {
            SpellBase spell = SpellRegistry.spellRegistry.get(message.spellName);
            if (spell != null) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                for (int k = 0; k < 40; ++k) {
                    if (random.nextBoolean()) {
                        ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), spell.red1 * 255.0f, spell.green1 * 255.0f, spell.blue1 * 255.0f, 0.5f, 2.5f, 48);
                        continue;
                    }
                    ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), spell.red2 * 255.0f, spell.green2 * 255.0f, spell.blue2 * 255.0f, 0.5f, 2.5f, 48);
                }
            }
            return null;
        }
    }
}

