/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import teamroots.roots.Constants;
import teamroots.roots.capability.IPlayerDataCapability;
import teamroots.roots.capability.PlayerDataProvider;
import teamroots.roots.effect.Effect;
import teamroots.roots.effect.EffectArcanism;
import teamroots.roots.effect.EffectFireResist;
import teamroots.roots.effect.EffectInvulnerability;
import teamroots.roots.effect.EffectNaturesCure;
import teamroots.roots.effect.EffectRegen;
import teamroots.roots.effect.EffectTimeStop;

public class EffectManager {
    public static Map<String, Effect> effects = new HashMap<String, Effect>();
    public static Effect effect_time_stop;
    public static Effect effect_invulnerability;
    public static Effect effect_fireresist;
    public static Effect effect_arcanism;
    public static Effect effect_naturescure;
    public static Effect effect_regen;

    public static void init() {
        effect_invulnerability = new EffectInvulnerability("effect_invulnerability", false);
        effects.put("effect_invulnerability", effect_invulnerability);
        effect_time_stop = new EffectTimeStop("effect_time_stop", false);
        effects.put("effect_time_stop", effect_time_stop);
        effect_fireresist = new EffectFireResist("effect_fireresist", false);
        effects.put("effect_fireresist", effect_fireresist);
        effect_arcanism = new EffectArcanism("effect_arcanism", false);
        effects.put("effect_arcanism", effect_arcanism);
        effect_naturescure = new EffectNaturesCure("effect_naturescure", false);
        effects.put("effect_naturescure", effect_naturescure);
        effect_regen = new EffectRegen("effect_regen", false);
        effects.put("effect_regen", effect_regen);
    }

    public static void assignEffect(EntityLivingBase entity, String effect, int duration, NBTTagCompound data) {
        if (!(entity instanceof EntityPlayer)) {
            if (!entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                entity.getEntityData().func_74782_a(Constants.EFFECT_TAG, (NBTBase)new NBTTagCompound());
            }
        } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null) && !((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
            ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74782_a(Constants.EFFECT_TAG, (NBTBase)new NBTTagCompound());
            ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).markDirty();
        }
        NBTTagCompound tag = null;
        if (!(entity instanceof EntityPlayer)) {
            tag = entity.getEntityData().func_74775_l(Constants.EFFECT_TAG);
        } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null)) {
            tag = ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG);
        }
        if (tag != null) {
            if (!tag.func_74764_b(effect)) {
                effects.get(effect).onApplied(entity, data);
            }
            tag.func_74768_a(effect, duration);
            tag.func_74782_a(effect + "_data", (NBTBase)data);
            if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null)) {
                ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).markDirty();
            }
        }
    }

    public static boolean hasEffect(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect);
                }
            } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
                return ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect);
            }
        }
        return false;
    }

    public static void setEffectData(EntityLivingBase entity, String effect, NBTTagCompound data) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                    entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74782_a(effect + "_data", (NBTBase)data);
                }
            } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
                ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74782_a(effect + "_data", (NBTBase)data);
                ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).markDirty();
            }
        }
    }

    public static NBTTagCompound getEffectData(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG) && entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect + "_data")) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74775_l(effect + "_data");
                }
            } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74764_b(Constants.EFFECT_TAG) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect + "_data")) {
                return ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74775_l(effect + "_data");
            }
        }
        return null;
    }

    public static int getDuration(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG) && entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect)) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74762_e(effect);
                }
            } else if (entity.hasCapability(PlayerDataProvider.playerDataCapability, null) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74764_b(Constants.EFFECT_TAG) && ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect)) {
                return ((IPlayerDataCapability)entity.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74762_e(effect);
            }
        }
        return 0;
    }

    public static void tickEffects(EntityLivingBase entity) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                NBTTagCompound tag;
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG) && (tag = entity.getEntityData().func_74775_l(Constants.EFFECT_TAG)) != null) {
                    NBTTagCompound data_tag;
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String s : tag.func_150296_c()) {
                        if (s.endsWith("_data") || (data_tag = tag.func_74775_l(s + "_data")) == null) continue;
                        effects.get(s).onTick(entity, tag.func_74762_e(s) - 1, data_tag);
                        tag.func_74768_a(s, tag.func_74762_e(s) - 1);
                        if (tag.func_74762_e(s) > 0) continue;
                        keys.add(s);
                    }
                    for (int i = 0; i < keys.size(); ++i) {
                        String s;
                        s = (String)keys.get(i);
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onEnd(entity, data_tag);
                        tag.func_82580_o(s);
                        tag.func_82580_o(s + "_data");
                        if (tag.func_150296_c().size() != 0) continue;
                        entity.getEntityData().func_82580_o(Constants.EFFECT_TAG);
                    }
                }
            } else {
                NBTTagCompound tag;
                EntityPlayer player = (EntityPlayer)entity;
                if (player.hasCapability(PlayerDataProvider.playerDataCapability, null) && (tag = ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_74775_l(Constants.EFFECT_TAG)) != null) {
                    NBTTagCompound data_tag;
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String s : tag.func_150296_c()) {
                        if (s.endsWith("_data") || (data_tag = tag.func_74775_l(s + "_data")) == null) continue;
                        effects.get(s).onTick(entity, tag.func_74762_e(s) - 1, data_tag);
                        tag.func_74768_a(s, tag.func_74762_e(s) - 1);
                        if (tag.func_74762_e(s) > 0) continue;
                        keys.add(s);
                    }
                    for (int i = 0; i < keys.size(); ++i) {
                        String s;
                        s = (String)keys.get(i);
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onEnd(entity, data_tag);
                        tag.func_82580_o(s);
                        tag.func_82580_o(s + "_data");
                        if (tag.func_150296_c().size() != 0) continue;
                        ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).getData().func_82580_o(Constants.EFFECT_TAG);
                    }
                    ((IPlayerDataCapability)player.getCapability(PlayerDataProvider.playerDataCapability, null)).markDirty();
                }
            }
        }
    }
}

