/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.collect;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class SimpleInvertibleDualMap<K, V> {
    private final Multimap<K, V> map = HashMultimap.create();
    private final Map<V, K> inverse = Maps.newHashMap();
    private Map<V, K> immutableInverse;

    private SimpleInvertibleDualMap() {
    }

    public static <K, V> SimpleInvertibleDualMap<K, V> create() {
        return new SimpleInvertibleDualMap<K, V>();
    }

    public Map<V, K> inverse() {
        return this.immutableInverse == null ? (this.immutableInverse = Collections.unmodifiableMap(this.inverse)) : this.immutableInverse;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(K key, V value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(K key, V value) {
        K oldKey = this.inverse.put(value, key);
        if (oldKey != null) {
            this.map.remove(oldKey, value);
        }
        return this.map.put(key, value);
    }

    public Collection<V> removeAll(K key) {
        Collection vs = this.map.removeAll(key);
        for (Object v : vs) {
            this.inverse.remove(v);
        }
        return vs;
    }

    @Nullable
    public K removeValue(V value) {
        K removed = this.inverse.remove(value);
        if (removed != null) {
            this.map.remove(removed, value);
        }
        return removed;
    }

    public boolean retainAll(Collection<K> keys) {
        boolean any = false;
        Iterator<K> iter = this.inverse.values().iterator();
        while (iter.hasNext()) {
            K key = iter.next();
            if (keys.contains(key)) continue;
            iter.remove();
            this.map.removeAll(key);
            any = true;
        }
        return any;
    }

    public boolean retainAllValues(Collection<V> values) {
        boolean any = false;
        Iterator iter = this.map.values().iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (values.contains(value)) continue;
            iter.remove();
            this.inverse.remove(value);
            any = true;
        }
        return any;
    }

    public void clear() {
        this.map.clear();
        this.inverse.clear();
    }

    public Collection<V> get(K key) {
        return Collections.unmodifiableCollection(this.map.get(key));
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Multiset<K> keys() {
        return Multisets.unmodifiableMultiset((Multiset)this.map.keys());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public Collection<Map.Entry<K, V>> entries() {
        return Collections.unmodifiableCollection(this.map.entries());
    }
}

