/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import javax.annotation.Nullable;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.cc.CCArgs;
import pl.asie.computronics.cc.ISidedPeripheral;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.sound.Instruction;
import pl.asie.computronics.util.sound.SoundBoard;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="opencomputers")})
public class TileSoundBoard
extends TileEntityPeripheralBase
implements IAudioSource,
ITickable,
ISidedPeripheral,
SidedEnvironment,
SoundBoard.ISoundHost {
    protected SoundBoard board;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return TileSoundBoard.this.field_145850_b;
        }

        @Override
        public BlockPos getSoundPos() {
            return TileSoundBoard.this.field_174879_c;
        }

        @Override
        public int getSoundDistance() {
            return Config.TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing direction) {
            packet.addReceiver(this);
        }

        @Override
        public boolean canMove() {
            return false;
        }
    };

    public TileSoundBoard() {
        super("sound");
        this.board = new SoundBoard(this);
    }

    public void func_73660_a() {
        super.update();
        this.board.update();
    }

    @Override
    @Optional.Method(modid="computercraft")
    public boolean canConnectPeripheralOnSide(EnumFacing side) {
        return side == this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.computercraft.soundBoard.rotation.FACING);
    }

    @Optional.Method(modid="computercraft")
    protected int checkChannel(CCArgs args, int index) throws LuaException {
        return this.board.checkChannel(args.checkInteger(index));
    }

    @Optional.Method(modid="computercraft")
    protected int checkChannel(CCArgs args) throws LuaException {
        return this.checkChannel(args, 0);
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"getModes", "getChannelCount", "setTotalVolume", "clear", "open", "close", "setWave", "setFrequency", "setLFSR", "delay", "setFM", "resetFM", "setAM", "resetAM", "setADSR", "resetEnvelope", "setVolume", "process"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        CCArgs args = new CCArgs(arguments);
        switch (method) {
            case 0: {
                return new Object[]{SoundBoard.compileModes()};
            }
            case 1: {
                return new Object[]{this.board.process.states.size()};
            }
            case 2: {
                this.board.setTotalVolume(args.checkDouble(0));
                return new Object[0];
            }
            case 3: {
                this.board.clear();
                return new Object[0];
            }
            case 4: {
                return this.board.tryAdd(new Instruction.Open(this.checkChannel(args)));
            }
            case 5: {
                return this.board.tryAdd(new Instruction.Close(this.checkChannel(args)));
            }
            case 6: {
                return this.board.setWave(args.checkInteger(0), args.checkInteger(1));
            }
            case 7: {
                return this.board.tryAdd(new Instruction.SetFrequency(this.checkChannel(args), (float)args.checkDouble(1)));
            }
            case 8: {
                return this.board.tryAdd(new Instruction.SetLFSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2)));
            }
            case 9: {
                return this.board.delay(args.checkInteger(0));
            }
            case 10: {
                return this.board.tryAdd(new Instruction.SetFM(this.checkChannel(args), this.checkChannel(args, 1), (float)args.checkDouble(2)));
            }
            case 11: {
                return this.board.tryAdd(new Instruction.ResetFM(this.checkChannel(args)));
            }
            case 12: {
                return this.board.tryAdd(new Instruction.SetAM(this.checkChannel(args), this.checkChannel(args, 1)));
            }
            case 13: {
                return this.board.tryAdd(new Instruction.ResetAM(this.checkChannel(args)));
            }
            case 14: {
                return this.board.tryAdd(new Instruction.SetADSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2), (float)args.checkDouble(3), args.checkInteger(4)));
            }
            case 15: {
                return this.board.tryAdd(new Instruction.ResetEnvelope(this.checkChannel(args)));
            }
            case 16: {
                return this.board.tryAdd(new Instruction.SetVolume(this.checkChannel(args), (float)args.checkDouble(1)));
            }
            case 17: {
                return this.board.process();
            }
        }
        return new Object[0];
    }

    @Override
    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        super.detach(computer);
        if (this.attachedComputersCC.isEmpty()) {
            this.board.clearAndStop();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.board.clearAndStop();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.board.clearAndStop();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.board.load(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.board.save(nbt);
        return nbt;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected void initOC(double s) {
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected void initOC() {
    }

    @Override
    @Nullable
    protected OCUtils.Device deviceInfo() {
        return null;
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public Node sidedNode(EnumFacing side) {
        return null;
    }

    @Optional.Method(modid="opencomputers")
    public boolean canConnect(EnumFacing side) {
        return false;
    }

    @Override
    public boolean tryConsumeEnergy(double energy) {
        return true;
    }

    @Override
    public String address() {
        for (IComputerAccess computer : this.attachedComputersCC) {
            if (computer == null) continue;
            return "cc_" + computer.getID();
        }
        return this.toString();
    }

    @Override
    public void sendMusicPacket(SoundCardPacket pkt) {
        this.internalSpeaker.receivePacket(pkt, null);
        pkt.sendPacket();
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos position() {
        return this.func_174877_v();
    }

    @Override
    public void setDirty() {
        this.func_70296_d();
    }

    @Override
    public int getSourceId() {
        return this.board.codecId;
    }

    @Override
    public boolean connectsAudio(EnumFacing side) {
        return false;
    }
}

