/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.security.Key;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.gui.container.ContainerCipherBlock;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.api.tile.IBundledRedstoneProvider;
import pl.asie.lib.util.Base64;

public class TileCipherBlock
extends TileEntityPeripheralBase
implements IBundledRedstoneProvider,
ISidedInventory,
ILockableContainer {
    private byte[] key = new byte[32];
    private byte[] iv = new byte[16];
    private SecretKeySpec skey;
    private Cipher cipher;
    private int bundledXORData;
    private boolean forceLocked;
    private LockCode code = LockCode.field_180162_a;

    public TileCipherBlock() {
        super("cipher");
        this.createInventory(6);
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateKey() {
        int i;
        byte[] realKey = new byte[16];
        for (i = 0; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == null) {
                this.key[i * 5] = 0;
                this.key[i * 5 + 1] = 0;
            } else {
                this.key[i * 5] = (byte)(Item.func_150891_b((Item)stack.func_77973_b()) & 0xFF);
                this.key[i * 5 + 1] = (byte)(Item.func_150891_b((Item)stack.func_77973_b()) >> 8);
            }
            if (stack.func_190926_b()) {
                this.key[i * 5 + 2] = 0;
                this.key[i * 5 + 3] = 0;
                this.iv[i * 2] = 0;
            } else {
                this.key[i * 5 + 2] = (byte)(stack.func_77952_i() & 3 | stack.func_190916_E() << 2);
                this.key[i * 5 + 3] = (byte)(stack.func_77952_i() >> 2);
                this.iv[i * 2] = (byte)(stack.func_77952_i() ^ stack.func_77952_i() >> 8);
            }
            if (stack.func_190926_b() || stack.func_77978_p() == null) {
                this.key[i * 5 + 4] = 0;
                this.iv[i * 2 + 1] = 0;
                continue;
            }
            this.key[i * 5 + 4] = (byte)stack.func_77978_p().hashCode();
            this.iv[i * 2 + 1] = (byte)(stack.func_77978_p().hashCode() >> 8);
        }
        for (i = 0; i < 16; ++i) {
            realKey[i] = (byte)(this.key[i] ^ this.key[i + 16]);
        }
        this.skey = new SecretKeySpec(realKey, "AES");
    }

    public String encrypt(String data) throws Exception {
        return this.encrypt(data.getBytes("UTF8"));
    }

    public String encrypt(byte[] data) throws Exception {
        if (this.cipher == null) {
            return "";
        }
        if (this.skey == null) {
            this.updateKey();
        }
        this.cipher.init(1, (Key)this.skey, new IvParameterSpec(this.iv));
        return Base64.encodeBytes(this.cipher.doFinal(data));
    }

    public String decrypt(String data) throws Exception {
        if (this.cipher == null) {
            return "";
        }
        if (this.skey == null) {
            this.updateKey();
        }
        this.cipher.init(2, (Key)this.skey, new IvParameterSpec(this.iv));
        return new String(this.cipher.doFinal(Base64.decode(data)), "UTF8");
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("processor", "Data encryption device", "Siekierka Innovations", "Cryptotron 5-X", new String[0]);
    }

    @Callback(doc="function(message:string):string; Encrypts the specified message", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] encrypt(Context context, Arguments args) throws Exception {
        if (args.count() >= 1) {
            if (args.isByteArray(0)) {
                return new Object[]{this.encrypt(args.checkByteArray(0))};
            }
            if (args.isString(0)) {
                return new Object[]{this.encrypt(args.checkString(0))};
            }
        }
        return null;
    }

    @Callback(doc="function(message:string):string; Decrypts the specified message", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] decrypt(Context context, Arguments args) throws Exception {
        if (args.count() >= 1 && args.isString(0)) {
            return new Object[]{this.decrypt(args.checkString(0))};
        }
        return null;
    }

    @Callback(doc="function():boolean; Returns whether the block is currently locked", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isLocked(Context context, Arguments args) throws Exception {
        return new Object[]{this.func_174893_q_()};
    }

    @Callback(doc="function(locked:boolean); Sets whether the block is currently locked")
    @Optional.Method(modid="opencomputers")
    public Object[] setLocked(Context context, Arguments args) throws Exception {
        if (args.count() == 1 && args.isBoolean(0)) {
            this.setLocked(args.checkBoolean(0));
        }
        return null;
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"encrypt", "decrypt", "isLocked", "setLocked"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            if (arguments.length == 1 && arguments[0] instanceof String) {
                String message = (String)arguments[0];
                switch (method) {
                    case 0: {
                        return new Object[]{this.encrypt(message)};
                    }
                    case 1: {
                        return new Object[]{this.decrypt(message)};
                    }
                }
            } else {
                if (arguments.length == 1 && arguments[0] instanceof Boolean && method == 3) {
                    this.setLocked((Boolean)arguments[0]);
                    return null;
                }
                if (method == 2) {
                    return new Object[]{this.func_174893_q_()};
                }
            }
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
        return null;
    }

    private int getBundledXORKey() {
        int key = 0;
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == null) continue;
            int stackId = Item.func_150891_b((Item)stack.func_77973_b());
            if (stackId < 4096) {
                stackId <<= 4;
            }
            key ^= stackId;
            key ^= stack.func_77952_i();
            key ^= stack.func_190916_E() * (193 * i);
        }
        return key;
    }

    private byte[] getBundledOutput() {
        int output = this.getBundledXORKey() ^ this.bundledXORData;
        byte[] out = new byte[16];
        for (int i = 0; i < 16; ++i) {
            out[i] = (output & 1) > 0 ? 15 : 0;
            output >>= 1;
        }
        return out;
    }

    public void updateOutputWires() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    @Override
    public void onSlotUpdate(int slot) {
        this.updateKey();
        this.updateOutputWires();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("cb_l") && Config.CIPHER_CAN_LOCK) {
            this.forceLocked = tag.func_74767_n("cb_l");
        }
        this.code = LockCode.func_180158_b((NBTTagCompound)tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.code != null) {
            this.code.func_180157_a(tag);
        }
        if (this.forceLocked) {
            tag.func_74757_a("cb_l", true);
        }
        return tag;
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("cb_l");
    }

    @Override
    public boolean canBundledConnectToInput(@Nullable EnumFacing side) {
        return this.field_145850_b != null && side == ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.cipher.rotation.FACING)).func_176746_e();
    }

    @Override
    public boolean canBundledConnectToOutput(@Nullable EnumFacing side) {
        return this.field_145850_b != null && side == ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.cipher.rotation.FACING)).func_176735_f();
    }

    @Override
    @Nullable
    public byte[] getBundledOutput(@Nullable EnumFacing side) {
        if (side == ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.cipher.rotation.FACING)).func_176735_f()) {
            return this.getBundledOutput();
        }
        return null;
    }

    @Override
    public void onBundledInputChange(@Nullable EnumFacing side, @Nullable byte[] data) {
        if (data != null && side == ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)Computronics.cipher.rotation.FACING)).func_176746_e()) {
            this.bundledXORData = 0;
            for (int i = 0; i < 16; ++i) {
                this.bundledXORData |= data[i] != 0 ? 1 << i : 0;
            }
            this.updateOutputWires();
        }
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (this.func_174893_q_()) {
            return ItemStack.field_190927_a;
        }
        return super.func_70301_a(slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.func_174893_q_()) {
            super.func_70299_a(slot, stack);
        }
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return !this.func_174893_q_() && slot == side.ordinal();
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return !this.func_174893_q_() && slot == side.ordinal();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (this.func_174893_q_()) {
            return new int[0];
        }
        return new int[]{side.ordinal()};
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.func_174893_q_() && super.func_70300_a(player);
    }

    public boolean func_174893_q_() {
        return this.forceLocked || this.code != null && !this.code.func_180160_a();
    }

    public void setLocked(boolean locked) {
        this.forceLocked = locked;
    }

    public void func_174892_a(LockCode code) {
        this.code = code;
    }

    public LockCode func_174891_i() {
        return this.code;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCipherBlock(this, playerInventory);
    }

    public String func_174875_k() {
        return "computronics:cipher";
    }
}

