/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.Camera;
import pl.asie.computronics.util.OCUtils;

public class TileCamera
extends TileEntityPeripheralBase
implements ITickable {
    private static final int CALL_LIMIT = 20;
    private final Camera camera = new Camera();
    private final Camera cameraRedstone = new Camera();
    private int tick;

    public TileCamera() {
        super("camera");
    }

    private EnumFacing getFacingDirection() {
        return Computronics.camera.getFacingDirection(this.field_145850_b, this.func_174877_v());
    }

    @Override
    public int requestCurrentRedstoneValue(@Nullable EnumFacing side) {
        double distance = this.cameraRedstone.getDistance();
        if (distance > 0.0) {
            return 15 - (int)Math.min(15L, Math.round(distance / 2.0));
        }
        return 0;
    }

    public void func_73660_a() {
        super.update();
        if (this.tick % 20 == 0 && Config.REDSTONE_REFRESH) {
            BlockPos pos = this.func_174877_v();
            this.cameraRedstone.ray(this.field_145850_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getFacingDirection(), 0.0f, 0.0f);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
        ++this.tick;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Rangefinder", "Siekierka Innovations", "Simple Spatiometer 1", new String[0]);
    }

    @Callback(doc="function([x:number, y:number]):number; Returns the distance to the block the ray is shot at with the specified x-y offset, or of the block directly in front", direct=true, limit=20)
    @Optional.Method(modid="opencomputers")
    public Object[] distance(Context context, Arguments args) {
        float x = 0.0f;
        float y = 0.0f;
        if (args.count() == 2) {
            x = (float)args.checkDouble(0);
            y = (float)args.checkDouble(1);
        }
        BlockPos pos = this.func_174877_v();
        this.camera.ray(this.field_145850_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getFacingDirection(), x, y);
        return new Object[]{this.camera.getDistance()};
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"distance"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (this.camera == null) {
            return new Object[0];
        }
        switch (method) {
            case 0: {
                float x = 0.0f;
                float y = 0.0f;
                if (arguments.length == 2 && arguments[0] instanceof Double && arguments[1] instanceof Double) {
                    x = ((Double)arguments[0]).floatValue();
                    y = ((Double)arguments[1]).floatValue();
                }
                BlockPos pos = this.func_174877_v();
                this.camera.ray(this.field_145850_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getFacingDirection(), x, y);
                return new Object[]{this.camera.getDistance()};
            }
        }
        return new Object[0];
    }
}

