/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import java.util.ArrayList;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.RadarUtils;

public class RobotUpgradeRadar
extends AbstractManagedEnvironment
implements DeviceInfo {
    private final EnvironmentHost container;
    private static final int CALL_LIMIT = 15;
    protected Map<String, String> deviceInfo;

    public RobotUpgradeRadar(EnvironmentHost container) {
        this.container = container;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector(Config.RADAR_ENERGY_COST_OC * (double)Config.RADAR_RANGE * 1.75).withComponent("radar", Visibility.Neighbors).create());
    }

    private int getDistance(Arguments args) {
        if (args.isInteger(0)) {
            return args.checkInteger(0);
        }
        return Config.RADAR_RANGE;
    }

    private AxisAlignedBB getBounds(int d) {
        int distance = Math.min(d, Config.RADAR_RANGE);
        if (distance < 1) {
            distance = 1;
        }
        return new AxisAlignedBB(this.container.xPosition() - 0.5, this.container.yPosition() - 0.5, this.container.zPosition() - 0.5, this.container.xPosition() + 0.5, this.container.yPosition() + 0.5, this.container.zPosition() + 0.5).func_72321_a((double)distance, (double)distance, (double)distance);
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all entities detected within the specified or the maximum range", direct=true, limit=15)
    public Object[] getEntities(Context context, Arguments args) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        int distance = this.getDistance(args);
        if (((Connector)this.node()).tryChangeBuffer(0.0 - Config.RADAR_ENERGY_COST_OC * (double)distance * 1.75)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), bounds, EntityPlayer.class));
            entities.addAll(RadarUtils.getEntities(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{entities.toArray()};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all players detected within the specified or the maximum range", direct=true, limit=15)
    public Object[] getPlayers(Context context, Arguments args) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        int distance = this.getDistance(args);
        if (((Connector)this.node()).tryChangeBuffer(0.0 - Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), bounds, EntityPlayer.class));
            context.pause(0.5);
        }
        return new Object[]{entities.toArray()};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all mobs detected within the specified or the maximum range", direct=true, limit=15)
    public Object[] getMobs(Context context, Arguments args) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        int distance = this.getDistance(args);
        if (((Connector)this.node()).tryChangeBuffer(0.0 - Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{entities.toArray()};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all items detected within the specified or the maximum range", direct=true, limit=15)
    public Object[] getItems(Context context, Arguments args) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        int distance = this.getDistance(args);
        if (((Connector)this.node()).tryChangeBuffer(0.0 - Config.RADAR_ENERGY_COST_OC * (double)distance * 2.0)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getItems(this.container.world(), this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), bounds, EntityItem.class));
            context.pause(0.5);
        }
        return new Object[]{entities.toArray()};
    }

    public Map<String, String> getDeviceInfo() {
        if (this.deviceInfo == null) {
            this.deviceInfo = new OCUtils.Device("multimedia", "Radar", "Trumbour Technology", "Detectotron M1 Mini", new String[0]).deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }
}

