/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry.entity;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.forestry.entity.EntityFlyingCreature;
import pl.asie.computronics.integration.forestry.nanomachines.SwarmProvider;
import pl.asie.computronics.util.StringUtil;

public class EntitySwarm
extends EntityFlyingCreature
implements IBeeHousing {
    public static final DamageSource beeDamageSource = new BeeDamageSource("computronics.sting", 5);
    public static final DamageSource beeDamageSourceSelf = new BeeDamageSource("computronics.sting.self", 1);
    private EntityPlayer player;
    private boolean aggressive = false;
    private static final List<String> damageTypesImmune = Arrays.asList(DamageSource.field_76368_d.func_76355_l(), DamageSource.field_76367_g.func_76355_l(), DamageSource.field_82728_o.func_76355_l(), DamageSource.field_82729_p.func_76355_l(), DamageSource.field_76379_h.func_76355_l());
    private static final DataParameter<Integer> DATAMANAGER_ID_AMPLIFIER = EntityDataManager.func_187226_a(EntitySwarm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATAMANAGER_ID_COLOR = EntityDataManager.func_187226_a(EntitySwarm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATAMANAGER_ID_TOLERANCE = EntityDataManager.func_187226_a(EntitySwarm.class, (DataSerializer)DataSerializers.field_187198_h);
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private final IBeeHousingInventory inventory;
    private final IBeeListener beeListener = new SwarmBeeListener();

    public EntitySwarm(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.inventory = new SwarmHousingInventory();
    }

    public EntitySwarm(World world, double x, double y, double z, ItemStack queen) {
        this(world);
        this.func_70105_a(1.0f, 1.0f);
        this.inventory.setQueen(queen);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            Biome biome;
            if (this.player != null) {
                if (this.player.field_70128_L || this.player.field_70170_p.field_73011_w.getDimension() != this.field_70170_p.field_73011_w.getDimension() || this.func_70055_a(Material.field_151586_h) || this.func_70638_az() == null && (this.player.func_70068_e((Entity)this) > 2500.0 && !this.func_70685_l((Entity)this.player) || this.player.func_70055_a(Material.field_151586_h))) {
                    this.func_70106_y();
                }
            } else if (!this.aggressive || this.func_70638_az() == null) {
                this.func_70106_y();
            }
            if (!this.isTolerant() && this.field_70170_p.func_82737_E() % 40L == (long)(this.hashCode() % 40) && !((biome = this.field_70170_p.func_180494_b(this.func_180425_c())) instanceof BiomeDesert) && (this.field_70170_p.func_72896_J() || this.field_70170_p.func_72911_I())) {
                this.func_70106_y();
            }
            if (this.beeLogic.canWork()) {
                this.beeLogic.doWork();
            }
        } else {
            int m = 10;
            int memberCountMax = this.getAmplifier() * m;
            memberCountMax = Math.max(Math.min(m, (int)((float)memberCountMax * (this.func_110143_aJ() / this.func_110138_aP()))), 1);
            for (int i = 0; i < memberCountMax; ++i) {
                double xPos = this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() * (this.field_70170_p.field_73012_v.nextBoolean() ? 0.5 : -0.5);
                double yPos = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + this.field_70170_p.field_73012_v.nextDouble() * (this.field_70170_p.field_73012_v.nextBoolean() ? 0.5 : -0.5);
                double zPos = this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() * (this.field_70170_p.field_73012_v.nextBoolean() ? 0.5 : -0.5);
                Computronics.proxy.spawnSwarmParticle(this.field_70170_p, xPos, yPos, zPos, this.getColor());
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    protected void func_70619_bc() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            if (target.field_70128_L || target == this.player && !this.aggressive || target.func_70055_a(Material.field_151586_h) || this.func_70068_e((Entity)target) > 25.0 && !this.func_70685_l((Entity)target)) {
                this.func_70624_b(null);
            } else {
                double dist = this.moveTo(target, target.func_70047_e(), 0.3f, 1.0f, 10.0f);
                if (dist < 1.0 && (!(target instanceof EntityPlayer) || BeeManager.armorApiaristHelper.wearsItems(target, "computronics:swarm", true) < 4)) {
                    target.func_70097_a(!this.aggressive ? beeDamageSource : beeDamageSourceSelf, (float)this.getAmplifier() + (this.aggressive ? 1.0f : 0.0f));
                }
            }
        } else if (this.player != null && (this.player.func_70068_e((Entity)this) < 100.0 || this.func_70685_l((Entity)this.player))) {
            if (this.player.func_184585_cz()) {
                Vec3d look = this.player.func_70040_Z();
                this.moveTo(this.player.field_70165_t + look.field_72450_a, this.player.field_70163_u + look.field_72448_b, this.player.field_70161_v + look.field_72449_c, this.player.field_70130_N / 2.0f, (this.player.field_70131_O / 2.0f + this.player.func_70047_e()) / 2.0f, 0.3f, 1.0f, 0.5f);
            } else {
                this.circle((EntityLivingBase)this.player, 3.0f, 0.3f, 1.0f, 1.0f);
            }
        }
    }

    private double circle(EntityLivingBase target, float yOffset, float modifier, float xFuzzy, float radius) {
        Vec3d pos = this.func_174791_d();
        double y = pos.field_72448_b;
        pos = pos.func_178786_a(0.0, pos.field_72448_b, 0.0);
        Vec3d targetPos = target.func_174791_d();
        if ((y = targetPos.field_72448_b + (double)yOffset - y) != 0.0) {
            y /= Math.abs(y);
        }
        targetPos = targetPos.func_178786_a(0.0, targetPos.field_72448_b, 0.0);
        Vec3d between = pos.func_178788_d(targetPos);
        if (between.field_72450_a <= 0.02 && between.field_72448_b <= 0.02) {
            between = between.func_72441_c(1.0, 0.0, 0.0);
        }
        Vec3d betweenX = between.func_186678_a(1.0 / Math.abs(between.field_72450_a));
        Vec3d targetRadius = betweenX.func_186678_a((double)radius / betweenX.func_72433_c()).func_178787_e(new Vec3d(0.0, 1.0, 0.0).func_72431_c(between).func_72432_b());
        Vec3d direction = targetRadius.func_178788_d(between).func_72441_c(0.0, y, 0.0).func_72432_b();
        double res = direction.field_72450_a * direction.field_72450_a + direction.field_72448_b * direction.field_72448_b + direction.field_72449_c * direction.field_72449_c;
        double ndeltaX = EntitySwarm.maxAbs(direction.field_72450_a, Math.signum(direction.field_72450_a), xFuzzy) * (double)(modifier /= 10.0f);
        double ndeltaY = EntitySwarm.maxAbs(direction.field_72448_b, Math.signum(direction.field_72448_b), xFuzzy) * (double)modifier;
        double ndeltaZ = EntitySwarm.maxAbs(direction.field_72449_c, Math.signum(direction.field_72449_c), xFuzzy) * (double)modifier;
        this.field_70159_w += EntitySwarm.minAbs(ndeltaX, Math.signum(ndeltaX), 0.5);
        this.field_70181_x += EntitySwarm.minAbs(ndeltaY, Math.signum(ndeltaY), 0.5);
        this.field_70179_y += EntitySwarm.minAbs(ndeltaZ, Math.signum(ndeltaZ), 0.5);
        return res;
    }

    private double moveTo(EntityLivingBase target, double yOffset, float modifier, float xFuzzy) {
        return this.moveTo(target, yOffset, modifier, xFuzzy, xFuzzy);
    }

    private double moveTo(EntityLivingBase target, double yOffset, float modifier, float xFuzzy, float xFuzzyAttack) {
        return this.moveTo(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70130_N / 2.0f, yOffset, modifier, xFuzzy, xFuzzyAttack);
    }

    private double moveTo(double x, double y, double z, double xzOffset, double yOffset, float modifier, float xFuzzy, float xFuzzyAttack) {
        double deltaX = x + xzOffset - (this.field_70165_t + (double)(this.field_70130_N / 4.0f));
        double deltaY = y + yOffset - (this.field_70163_u + (double)(this.field_70131_O / 4.0f));
        double deltaZ = z + xzOffset - (this.field_70161_v + (double)(this.field_70130_N / 4.0f));
        double res = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        Vec3d vec3 = new Vec3d(deltaX, deltaY, deltaZ);
        vec3 = vec3.func_72432_b();
        modifier /= 10.0f;
        if (res < 9.0) {
            xFuzzy = xFuzzyAttack;
        }
        double ndeltaX = EntitySwarm.maxAbs(vec3.field_72450_a, Math.signum(vec3.field_72450_a), xFuzzy) * (double)modifier;
        double ndeltaY = EntitySwarm.maxAbs(vec3.field_72448_b, Math.signum(vec3.field_72448_b), xFuzzy) * (double)modifier;
        double ndeltaZ = EntitySwarm.maxAbs(vec3.field_72449_c, Math.signum(vec3.field_72449_c), xFuzzy) * (double)modifier;
        this.field_70159_w += EntitySwarm.minAbs(ndeltaX, Math.signum(ndeltaX), 0.5);
        this.field_70181_x += EntitySwarm.minAbs(ndeltaY, Math.signum(ndeltaY), 0.5);
        this.field_70179_y += EntitySwarm.minAbs(ndeltaZ, Math.signum(ndeltaZ), 0.5);
        return res;
    }

    private static double minAbs(double number, double sig, double targetMin) {
        double result = number;
        result = sig > 0.0 ? Math.min(result, targetMin) : Math.max(result, -targetMin);
        return result;
    }

    private static double maxAbs(double number, double sig, double targetMax) {
        double result = number;
        result = sig > 0.0 ? Math.max(result, targetMax) : Math.min(result, -targetMax);
        return result;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.player != null && player == this.player && player.func_70093_af() && hand == EnumHand.MAIN_HAND && player.func_184586_b(hand).func_190926_b()) {
            this.func_70106_y();
            SwarmProvider.swingItem(player, hand, null);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !damageTypesImmune.contains(source.func_76355_l()) && (this.player == null || source.func_76346_g() != this.player) && super.func_70097_a(source, Math.min(amount, 2.0f));
    }

    protected void func_70665_d(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATAMANAGER_ID_AMPLIFIER, (Object)1);
        this.field_70180_af.func_187214_a(DATAMANAGER_ID_COLOR, (Object)0xF0F000);
        this.field_70180_af.func_187214_a(DATAMANAGER_ID_TOLERANCE, (Object)false);
    }

    public void setAmplifier(int amplifier) {
        this.field_70180_af.func_187227_b(DATAMANAGER_ID_AMPLIFIER, (Object)Math.max(amplifier, 1));
    }

    public int getAmplifier() {
        return (Integer)this.field_70180_af.func_187225_a(DATAMANAGER_ID_AMPLIFIER);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(DATAMANAGER_ID_COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(DATAMANAGER_ID_COLOR);
    }

    public void setTolerant(boolean tolerant) {
        this.field_70180_af.func_187227_b(DATAMANAGER_ID_TOLERANCE, (Object)tolerant);
    }

    public boolean isTolerant() {
        return (Boolean)this.field_70180_af.func_187225_a(DATAMANAGER_ID_TOLERANCE);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable EntityPlayer player) {
        this.player = player;
    }

    public void setAggressive(boolean aggressive) {
        this.aggressive = aggressive;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_70624_b(@Nullable EntityLivingBase entity) {
        if (!(entity == this || this.player != null && entity == this.player || entity instanceof FakePlayer)) {
            super.func_70624_b(entity);
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.getColor();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184181_aa() {
        return super.func_184181_aa();
    }

    protected SoundEvent func_184184_Z() {
        return super.func_184184_Z();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.0f;
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    protected void func_85033_bc() {
    }

    protected void func_82167_n(Entity entity) {
    }

    public void func_70108_f(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.player != null && entity != this.player && this.player.func_184585_cz()) {
            entity.field_70159_w /= 2.0;
            entity.field_70181_x /= 2.0;
            entity.field_70179_y /= 2.0;
            double deltaX = this.field_70165_t - entity.field_70165_t;
            double deltaZ = this.field_70161_v - entity.field_70161_v;
            double modifier = 0.1 * (double)(this.func_110143_aJ() / this.func_110138_aP());
            float dist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            entity.field_70159_w -= deltaX / (double)dist * modifier;
            entity.field_70179_y -= deltaZ / (double)dist * modifier;
            entity.field_70160_al = true;
            entity.field_70133_I = true;
        }
    }

    public void func_70653_a(Entity entity, float damage, double deltaX, double deltaZ) {
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("swarm:amplifier")) {
            this.setAmplifier(tag.func_74762_e("swarm:amplifier"));
        }
        this.beeLogic.readFromNBT(tag);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("swarm:amplifier", this.getAmplifier());
        this.beeLogic.writeToNBT(tag);
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singletonList(SwarmBeeModifier.instance);
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singletonList(this.beeListener);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome((Biome)this.getBiome(), (World)this.field_70170_p, (BlockPos)this.func_180425_c());
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.getBiome().func_76727_i());
    }

    public int getBlockLightValue() {
        return this.field_70170_p.func_175671_l(this.func_180425_c().func_177982_a(0, 1, 0));
    }

    public boolean canBlockSeeTheSky() {
        return this.field_70170_p.func_175710_j(this.func_180425_c().func_177982_a(0, 1, 0));
    }

    public World getWorldObj() {
        return this.field_70170_p;
    }

    public Biome getBiome() {
        return this.field_70170_p.func_180494_b(this.func_180425_c());
    }

    public boolean isRaining() {
        return this.field_70170_p.func_175727_C(this.func_180425_c().func_177984_a());
    }

    @Nullable
    public GameProfile getOwner() {
        return this.player != null ? this.player.func_146103_bH() : null;
    }

    public Vec3d getBeeFXCoordinates() {
        return new Vec3d(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v);
    }

    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    public BlockPos getCoordinates() {
        return this.func_180425_c();
    }

    public static class SwarmBeeModifier
    extends DefaultBeeModifier {
        public static final IBeeModifier instance = new SwarmBeeModifier();

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 0.5f;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 1.1f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 100.0f;
        }
    }

    public class SwarmBeeListener
    extends DefaultBeeListener {
        public void onQueenDeath() {
            super.onQueenDeath();
            EntitySwarm.this.func_70106_y();
        }
    }

    public static class SwarmHousingInventory
    implements IBeeHousingInventory {
        private ItemStack queenStack;

        public ItemStack getQueen() {
            return this.queenStack;
        }

        @Nullable
        public ItemStack getDrone() {
            return null;
        }

        public void setQueen(ItemStack stack) {
            this.queenStack = stack;
        }

        public void setDrone(ItemStack stack) {
        }

        public boolean addProduct(ItemStack product, boolean all) {
            return true;
        }
    }

    public static class BeeDamageSource
    extends DamageSource {
        private int numCauses;

        public BeeDamageSource(String key, int numCauses) {
            super(key);
            this.func_76348_h();
            this.func_151518_m();
            this.numCauses = numCauses;
        }

        public ITextComponent func_151519_b(EntityLivingBase victim) {
            EntityLivingBase damager = victim.func_94060_bK();
            String format = "death.attack." + this.field_76373_n + (this.numCauses > 1 ? "." + (victim.field_70170_p.field_73012_v.nextInt(this.numCauses) + 1) : "");
            String withCauseFormat = format + ".player";
            return damager != null && StringUtil.canTranslate(withCauseFormat) ? new TextComponentTranslation(withCauseFormat, new Object[]{victim.func_145748_c_(), damager.func_145748_c_()}) : new TextComponentTranslation(format, new Object[]{victim.func_145748_c_()});
        }
    }
}

