/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc.multiperipheral;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralProvider;
import pl.asie.computronics.cc.multiperipheral.DefaultMultiPeripheral;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheral;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;

public class MultiPeripheralProvider
implements IPeripheralProvider {
    ArrayList<IMultiPeripheralProvider> peripheralProviders = new ArrayList();
    public static Logger log = LogManager.getLogger((String)"computronics-multiperipheral");
    private List<IPeripheralProvider> ccPeripheralProviders;
    private boolean ccErrored = false;

    public MultiPeripheralProvider(ArrayList<IMultiPeripheralProvider> peripheralProviders) {
        this.peripheralProviders = peripheralProviders;
    }

    public IPeripheral getPeripheral(World world, BlockPos pos, EnumFacing side) {
        ArrayList<IMultiPeripheral> periphs = new ArrayList<IMultiPeripheral>();
        for (IMultiPeripheralProvider peripheralProvider : this.peripheralProviders) {
            IMultiPeripheral p = peripheralProvider.getPeripheral(world, pos, side);
            if (p == null) continue;
            periphs.add(p);
        }
        if (Config.CC_ALL_MULTI_PERIPHERALS) {
            this.getAllPeripherals(periphs, world, pos, side);
        }
        if (!periphs.isEmpty()) {
            return new MultiPeripheral(periphs, world, pos);
        }
        return null;
    }

    private void getCCProviders() {
        List ccperiphs;
        if (this.ccErrored || this.ccPeripheralProviders != null) {
            return;
        }
        this.ccPeripheralProviders = new ArrayList<IPeripheralProvider>();
        try {
            Class<?> cclass = Class.forName("dan200.computercraft.ComputerCraft");
            Field cfield = cclass.getDeclaredField("peripheralProviders");
            cfield.setAccessible(true);
            ccperiphs = (List)cfield.get(null);
        }
        catch (IllegalAccessException e) {
            log.error("Could not access ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find ComputerCraft main class");
            this.ccErrored = true;
            return;
        }
        catch (NoSuchFieldException e) {
            log.error("Could not find ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (ClassCastException e) {
            log.error("Could not cast ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (Exception e) {
            log.error("Could not wrap ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        if (ccperiphs == null) {
            return;
        }
        if (Config.CC_ALWAYS_FIRST) {
            for (int i = 0; i < ccperiphs.size(); ++i) {
                Object o = ccperiphs.get(i);
                if (o == null || !(o instanceof MultiPeripheralProvider)) continue;
                ccperiphs.remove(i);
                ccperiphs.add(0, o);
                break;
            }
        }
        for (Object ccperiph : ccperiphs) {
            if (ccperiph == null || !(ccperiph instanceof IPeripheralProvider) || ccperiph instanceof MultiPeripheralProvider || Mods.isLoaded("OpenPeripheralCore")) continue;
            this.ccPeripheralProviders.add((IPeripheralProvider)ccperiph);
        }
    }

    private void getAllPeripherals(ArrayList<IMultiPeripheral> periphs, World world, BlockPos pos, EnumFacing side) {
        if (this.ccErrored) {
            return;
        }
        if (this.ccPeripheralProviders == null) {
            this.getCCProviders();
        }
        try {
            for (IPeripheralProvider peripheralProvider : this.ccPeripheralProviders) {
                if (peripheralProvider == null) continue;
                try {
                    IPeripheral peripheral = peripheralProvider.getPeripheral(world, pos, side);
                    if (peripheral == null) continue;
                    periphs.add(new DefaultMultiPeripheral(peripheral));
                }
                catch (Exception e) {
                    log.warn("An exception got thrown trying to get a peripheral from provider " + peripheralProvider.getClass().toString(), (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("An error occured trying to get all a peripheral from provider " + peripheralProvider.getClass().toString(), t);
                }
            }
        }
        catch (Exception e) {
            log.warn("An exception got thrown trying to get all peripherals", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("An error occured trying to get all peripherals", t);
        }
    }

    public void sort() {
        if (this.ccPeripheralProviders == null && !this.ccErrored && Config.CC_ALWAYS_FIRST) {
            this.getCCProviders();
        }
    }
}

