/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockSoundBoard;
import pl.asie.computronics.cc.CCPeripheralProvider;
import pl.asie.computronics.cc.CameraTurtleUpgrade;
import pl.asie.computronics.cc.MusicalTurtleUpgrade;
import pl.asie.computronics.cc.ParticleTurtleUpgrade;
import pl.asie.computronics.cc.RadarTurtleUpgrade;
import pl.asie.computronics.cc.SpeakingTurtleUpgrade;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheralProvider;
import pl.asie.computronics.integration.flamingo.DriverFlamingo;
import pl.asie.computronics.integration.storagedrawers.DriverDrawerGroup;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileSoundBoard;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.computronics.util.RecipeUtils;

public class IntegrationComputerCraft {
    private final Compat compat;
    private final Computronics computronics;
    private MultiPeripheralProvider multiPeripheralProvider;
    public BlockSoundBoard soundBoard;

    public IntegrationComputerCraft(Computronics computronics) {
        this.computronics = computronics;
        this.compat = computronics.compat;
    }

    @Optional.Method(modid="computercraft")
    public void preInit() {
        if (Config.CC_SOUND_BOARD) {
            this.soundBoard = new BlockSoundBoard();
            Computronics.instance.registerBlockWithTileEntity(this.soundBoard, TileSoundBoard.class, "sound_board");
        }
    }

    @Optional.Method(modid="computercraft")
    public void init() {
        if (Mods.isLoaded("storagedrawers") && this.compat.isCompatEnabled("enableStorageDrawersDriver")) {
            Computronics.registerMultiPeripheralProvider(new DriverDrawerGroup.CCDriver());
        }
        if (Mods.isLoaded("flamingo") && this.compat.isCompatEnabled("enableFlamingoDriver")) {
            Computronics.registerMultiPeripheralProvider(new DriverFlamingo.CCDriver());
        }
        Computronics.registerMultiPeripheralProvider(new CCPeripheralProvider());
        this.multiPeripheralProvider = new MultiPeripheralProvider(Computronics.peripheralRegistry.peripheralProviders);
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)this.multiPeripheralProvider);
        if (this.computronics.isEnabled("ccTurtleUpgrades", true)) {
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new SpeakingTurtleUpgrade("computronics.turtle_speaking"));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new RadarTurtleUpgrade("computronics.turtle_radar"));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new MusicalTurtleUpgrade("computronics.turtle_noteblock"));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new ParticleTurtleUpgrade("computronics.turtle_fx"));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new CameraTurtleUpgrade("computronics.turtle_camera"));
        }
        if (Computronics.tapeReader != null) {
            TileTapeDrive.initCCFilesystem();
        }
    }

    @Optional.Method(modid="computercraft")
    public void postInit() {
        if (Config.CC_SOUND_BOARD) {
            if (Computronics.ironNote != null && Computronics.speaker != null) {
                RecipeUtils.addShapedRecipe(new ItemStack((Block)this.soundBoard, 1, 0), "ggg", "gcs", "ggg", Character.valueOf('c'), Computronics.ironNote, Character.valueOf('s'), Computronics.speaker, Character.valueOf('g'), "ingotGold");
            } else {
                Computronics.log.warn("Could not add Sound Board Recipe because Iron Note Block or Speaker is disabled in the config.");
            }
        }
    }

    public void serverStart() {
        if (this.multiPeripheralProvider != null && Config.CC_ALWAYS_FIRST) {
            this.multiPeripheralProvider.sort();
        }
    }
}

