/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.RadarUtils;
import pl.asie.computronics.util.TableUtils;

public class CCRadarProxy {
    private static AxisAlignedBB getBounds(BlockPos pos, int d) {
        int distance = Math.min(d, Config.RADAR_RANGE);
        if (distance < 1) {
            distance = 1;
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_72321_a((double)distance, (double)distance, (double)distance);
    }

    @Optional.Method(modid="computercraft")
    public static String[] getMethodNames() {
        return new String[]{"getEntities", "getPlayers", "getMobs", "getItems"};
    }

    @Optional.Method(modid="computercraft")
    public static Object[] callMethod(World world, BlockPos pos, IComputerAccess computer, ILuaContext context, int method, Object[] arguments, Object powerProvider) throws LuaException, InterruptedException {
        int distance = Config.RADAR_RANGE;
        if (arguments.length >= 1 && arguments[0] instanceof Double && ((distance = ((Double)arguments[0]).intValue()) <= 0 || distance > Config.RADAR_RANGE)) {
            distance = Config.RADAR_RANGE;
        }
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance;
        if (method == 0) {
            energyNeeded *= 1.75;
        } else if (method == 3) {
            energyNeeded *= 2.0;
        }
        if (powerProvider instanceof ITurtleAccess && ((ITurtleAccess)powerProvider).isFuelNeeded() && !((ITurtleAccess)powerProvider).consumeFuel((int)Math.ceil(energyNeeded))) {
            return null;
        }
        AxisAlignedBB bounds = CCRadarProxy.getBounds(pos, distance);
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        if (method == 0 || method == 1) {
            entities.addAll(RadarUtils.getEntities(world, pos, bounds, EntityPlayer.class));
        }
        if (method == 0 || method == 2) {
            entities.addAll(RadarUtils.getEntities(world, pos, bounds, EntityLiving.class));
        }
        if (method == 3) {
            entities.addAll(RadarUtils.getItems(world, pos, bounds, EntityItem.class));
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }
}

