/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketClientHandler;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.AudioUtil;
import pl.asie.computronics.util.sound.Instruction;
import pl.asie.lib.audio.StreamingAudioPlayer;
import pl.asie.lib.network.Packet;

@SideOnly(value=Side.CLIENT)
public class SoundCardPacketClientHandler
extends AudioPacketClientHandler {
    private Map<String, AudioUtil.AudioProcess> processMap = new HashMap<String, AudioUtil.AudioProcess>();
    private int sampleRate = Config.SOUND_SAMPLE_RATE;

    public void setProcess(String address, @Nullable AudioUtil.AudioProcess process) {
        if (process != null) {
            this.processMap.put(address, process);
        } else {
            this.processMap.remove(address);
        }
    }

    @Override
    protected void readData(Packet packet, int packetId, int codecId) throws IOException {
        String address = packet.readString();
        int size = packet.readInt();
        ArrayDeque<Instruction> buffer = new ArrayDeque<Instruction>();
        block16: for (int i = 0; i < size; ++i) {
            byte type = packet.readByte();
            switch (type) {
                case 0: {
                    buffer.add(new Instruction.Open(packet.readByte()));
                    continue block16;
                }
                case 1: {
                    buffer.add(new Instruction.Close(packet.readByte()));
                    continue block16;
                }
                case 2: {
                    buffer.add(new Instruction.SetWave(packet.readByte(), AudioType.fromIndex(packet.readInt())));
                    continue block16;
                }
                case 3: {
                    buffer.add(new Instruction.Delay(packet.readInt()));
                    continue block16;
                }
                case 4: {
                    buffer.add(new Instruction.SetFM(packet.readByte(), packet.readInt(), packet.readFloat()));
                    continue block16;
                }
                case 5: {
                    buffer.add(new Instruction.ResetFM(packet.readByte()));
                    continue block16;
                }
                case 6: {
                    buffer.add(new Instruction.SetAM(packet.readByte(), packet.readInt()));
                    continue block16;
                }
                case 7: {
                    buffer.add(new Instruction.ResetAM(packet.readByte()));
                    continue block16;
                }
                case 8: {
                    buffer.add(new Instruction.SetADSR(packet.readByte(), packet.readInt(), packet.readInt(), packet.readFloat(), packet.readInt()));
                    continue block16;
                }
                case 9: {
                    buffer.add(new Instruction.ResetEnvelope(packet.readByte()));
                    continue block16;
                }
                case 10: {
                    buffer.add(new Instruction.SetVolume(packet.readByte(), packet.readFloat()));
                    continue block16;
                }
                case 11: {
                    buffer.add(new Instruction.SetFrequency(packet.readByte(), packet.readFloat()));
                    continue block16;
                }
                case 12: {
                    buffer.add(new Instruction.SetWhiteNoise(packet.readByte()));
                    continue block16;
                }
                case 13: {
                    buffer.add(new Instruction.SetLFSR(packet.readByte(), packet.readInt(), packet.readInt()));
                }
            }
        }
        if (!this.processMap.containsKey(address)) {
            this.setProcess(address, new AudioUtil.AudioProcess(Config.SOUND_CARD_CHANNEL_COUNT));
        }
        AudioUtil.AudioProcess process = this.processMap.get(address);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        while (!buffer.isEmpty() || process.delay > 0) {
            if (process.delay > 0) {
                int sampleCount = process.delay * this.sampleRate / 1000;
                for (int i = 0; i < sampleCount; ++i) {
                    double sample = 0.0;
                    for (AudioUtil.State state : process.states) {
                        sample += state.gate.getValue(process, state);
                    }
                    sample = Math.max(Math.min(sample, 1.0), -1.0);
                    int value = (byte)(sample * 127.0) ^ 0x80;
                    data.write((byte)value);
                }
                process.delay = 0;
                continue;
            }
            Instruction inst = (Instruction)buffer.poll();
            inst.encounter(process);
        }
        if (data.size() > 0) {
            StreamingAudioPlayer codec = Computronics.instance.soundCardAudio.getPlayer(codecId);
            codec.setSampleRate(this.sampleRate);
            codec.push(data.toByteArray());
        }
    }

    @Override
    protected void playData(int packetId, int codecId, int x, int y, int z, int distance, byte volume, boolean canMove) {
        StreamingAudioPlayer codec = Computronics.instance.soundCardAudio.getPlayer(codecId);
        codec.setHearing(distance, (float)(volume * Config.SOUND_VOLUME) / 16129.0f);
        try {
            codec.play(canMove ? "computronics:soundcard-" + codecId : null, x, y, z, 1.0f);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

