/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.CommonProxy;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.audio.AudioPacketClientHandlerDFPWM;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.audio.SoundCardPacketClientHandler;
import pl.asie.computronics.item.ItemPortableTapeDrive;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.oc.client.RackMountableRenderer;
import pl.asie.computronics.oc.client.UpgradeRenderer;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.TapeScrollEventHandler;
import pl.asie.computronics.util.boom.SelfDestruct;
import pl.asie.computronics.util.internal.IBlockWithColor;
import pl.asie.computronics.util.internal.IItemWithColor;
import pl.asie.computronics.util.sound.Audio;
import pl.asie.lib.network.Packet;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private final List<Item> coloredItems = new ArrayList<Item>();
    private final List<Block> coloredBlocks = new ArrayList<Block>();

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void registerAudioHandlers() {
        super.registerAudioHandlers();
        AudioPacketRegistry.INSTANCE.registerClientHandler(AudioPacketDFPWM.class, new AudioPacketClientHandlerDFPWM());
        AudioPacketRegistry.INSTANCE.registerClientHandler(SoundCardPacket.class, new SoundCardPacketClientHandler());
    }

    @Override
    public void registerEntities() {
        super.registerEntities();
    }

    @Override
    public void registerItemModel(Item item, int meta, String name) {
        if (item instanceof IItemWithColor) {
            this.coloredItems.add(item);
        }
        if (name.contains("#")) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name.split("#")[0], name.split("#")[1]));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    @Override
    public void registerItemModel(Block block, int meta, String name) {
        if (block instanceof IBlockWithColor) {
            this.coloredBlocks.add(block);
        }
        super.registerItemModel(block, meta, name);
    }

    @Override
    public void preInit() {
        super.preInit();
        if (Mods.isLoaded("opencomputers") && Computronics.forestry != null) {
            Computronics.forestry.registerOCEntityRenderers();
        }
        ItemPortableTapeDrive.MeshDefinition.registerRenderers();
    }

    @Override
    public void init() {
        super.init();
        Audio.init();
        this.registerRenderers();
        this.registerColors();
        MinecraftForge.EVENT_BUS.register((Object)new TapeScrollEventHandler());
    }

    private void registerColors() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return stack.func_77973_b() instanceof IItemWithColor ? ((IItemWithColor)stack.func_77973_b()).getColorFromItemstack(stack, tintIndex) : -1;
            }
        }, this.coloredItems.toArray(new Item[this.coloredItems.size()]));
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return pos != null && state.func_177230_c() instanceof IBlockWithColor ? ((IBlockWithColor)state.func_177230_c()).colorMultiplier(state, worldIn, pos, tintIndex) : -1;
            }
        }, this.coloredBlocks.toArray(new Block[this.coloredBlocks.size()]));
    }

    public void registerRenderers() {
        if (Mods.isLoaded("opencomputers")) {
            this.registerOpenComputersRenderers();
        }
    }

    @Override
    public void onServerStop() {
        Computronics.instance.audio.removeAll();
        Computronics.instance.soundCardAudio.removeAll();
    }

    @Override
    public void goBoom(Packet p) throws IOException {
        double x = p.readDouble();
        double y = p.readDouble();
        double z = p.readDouble();
        float force = p.readFloat();
        boolean destroyBlocks = p.readByte() != 0;
        Minecraft minecraft = Minecraft.func_71410_x();
        SelfDestruct explosion = new SelfDestruct((World)minecraft.field_71441_e, null, x, y, z, force, destroyBlocks);
        int size = p.readInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(size);
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        for (int i1 = 0; i1 < size; ++i1) {
            int j1 = p.readByte() + i;
            int k1 = p.readByte() + j;
            int l1 = p.readByte() + k;
            list.add(new BlockPos(j1, k1, l1));
        }
        explosion.func_180343_e().clear();
        explosion.func_180343_e().addAll(list);
        explosion.func_77279_a(true);
        minecraft.field_71439_g.field_70159_w += (double)p.readFloat();
        minecraft.field_71439_g.field_70181_x += (double)p.readFloat();
        minecraft.field_71439_g.field_70179_y += (double)p.readFloat();
    }

    @Override
    @Optional.Method(modid="forestry")
    public void spawnSwarmParticle(World world, double xPos, double yPos, double zPos, int color) {
        Computronics.forestry.spawnSwarmParticle(world, xPos, yPos, zPos, color);
    }

    @Optional.Method(modid="opencomputers")
    private void registerOpenComputersRenderers() {
        if (IntegrationOpenComputers.upgradeRenderer == null) {
            IntegrationOpenComputers.upgradeRenderer = new UpgradeRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)IntegrationOpenComputers.upgradeRenderer);
        if (IntegrationOpenComputers.mountableRenderer == null) {
            IntegrationOpenComputers.mountableRenderer = new RackMountableRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)IntegrationOpenComputers.mountableRenderer);
    }
}

