/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.util.ClientUtils;
import fi.dy.masa.justenoughdimensions.util.world.DragonFightManagerDummy;
import fi.dy.masa.justenoughdimensions.util.world.VoidTeleport;
import fi.dy.masa.justenoughdimensions.util.world.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.ChunkGeneratorEndJED;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import fi.dy.masa.justenoughdimensions.world.WorldProviderJED;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderEndJED
extends WorldProviderEnd
implements IWorldProviderJED {
    private static final Field field_dragonFightManager = ReflectionHelper.findField(WorldProviderEnd.class, (String[])new String[]{"field_186064_g", "dragonFightManager"});
    protected JEDWorldProperties properties;
    private boolean worldInfoSet;
    protected VoidTeleport.VoidTeleportData voidTeleport = null;
    protected VoidTeleport.VoidTeleportData skyTeleport = null;
    protected int teleportCounter;

    @Override
    public boolean getWorldInfoHasBeenSet() {
        return this.worldInfoSet;
    }

    public void setDimension(int dimension) {
        super.setDimension(dimension);
        this.properties = JEDWorldProperties.getOrCreateProperties(dimension);
        if (this.field_76579_a != null && !this.getWorldInfoHasBeenSet()) {
            WorldInfoUtils.loadAndSetCustomWorldInfo(this.field_76579_a);
            this.field_191067_f = this.properties.getHasSkyLight() != null ? this.properties.getHasSkyLight() : this.field_191067_f;
            this.worldInfoSet = true;
            this.skyTeleport = VoidTeleport.VoidTeleportData.fromJson(this.properties.getNestedObject("sky_teleport"), this.getDimension());
            this.voidTeleport = VoidTeleport.VoidTeleportData.fromJson(this.properties.getNestedObject("void_teleport"), this.getDimension());
            if (!this.field_76579_a.field_72995_K && this.properties.getDisableDragon()) {
                NBTTagCompound tag = this.field_76579_a.func_72912_H().getDimensionData(dimension);
                try {
                    JustEnoughDimensions.logInfo("Trying to override the DragonFightManager in dimension {}...", dimension);
                    field_dragonFightManager.set(this, (Object)new DragonFightManagerDummy((WorldServer)this.field_76579_a, tag.func_74775_l("DragonFight")));
                    JustEnoughDimensions.logInfo("Overrode the DragonFightManager with '{}'", DragonFightManagerDummy.class.getName());
                }
                catch (Exception e) {
                    JustEnoughDimensions.logger.warn("Failed to override the DragonFightManager in dimension {}", (Object)dimension);
                }
            }
        }
    }

    public IChunkGenerator func_186060_c() {
        if (this.properties.getDisableEndSpikes()) {
            JustEnoughDimensions.logInfo("Using '{}' in dimension {}", ChunkGeneratorEndJED.class.getName(), this.getDimension());
            return new ChunkGeneratorEndJED(this.field_76579_a, this.field_76579_a.func_72912_H().func_76089_r(), this.field_76579_a.func_72905_C(), this.func_177496_h());
        }
        return super.func_186060_c();
    }

    public DimensionType func_186058_p() {
        DimensionType type = null;
        try {
            type = DimensionManager.getProviderType((int)this.getDimension());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type != null ? type : super.func_186058_p();
    }

    @Override
    public void setJEDProperties(JEDWorldProperties properties) {
        this.properties = properties;
        ClientUtils.setRenderersFrom((WorldProvider)this, this.properties.getFullJEDProperties());
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return this.properties.canSleepHere() != null ? this.properties.canSleepHere() : super.canSleepAt(player, pos);
    }

    public boolean func_76567_e() {
        return this.properties.canRespawnHere() != null ? this.properties.canRespawnHere() : false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        if (this.properties.getRespawnDimension() != null) {
            return this.properties.getRespawnDimension();
        }
        return this.func_76567_e() ? this.getDimension() : 0;
    }

    public void func_186059_r() {
        super.func_186059_r();
        if (++this.teleportCounter >= this.properties.getVoidTeleportInterval()) {
            VoidTeleport.tryVoidTeleportEntities(this.field_76579_a, this.voidTeleport, this.skyTeleport);
            this.teleportCounter = 0;
        }
    }

    public float[] func_177497_p() {
        if (this.properties.getCustomLightBrightnessTable() != null) {
            return this.properties.getCustomLightBrightnessTable();
        }
        return super.func_177497_p();
    }

    public int getDayCycleLength() {
        return this.properties.getDayLength() + this.properties.getNightLength();
    }

    public int func_76559_b(long worldTime) {
        long cycleLength = this.getDayCycleLength();
        return (int)(worldTime / cycleLength % 8L + 8L) % 8;
    }

    public void setWorldTime(long time) {
        time = WorldProviderJED.getNewWorldTime(time, this.getWorldTime(), this.properties);
        super.setWorldTime(time);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        if (this.properties.getUseCustomDayCycle()) {
            return WorldProviderJED.calculateCelestialAngle(this.field_76579_a, this.properties, this.getDayCycleLength(), worldTime, partialTicks);
        }
        if (this.properties.getUseCustomCelestialAngleRange()) {
            return WorldProviderJED.getCustomCelestialAngleValue(this.field_76579_a, this.properties, this.getDayCycleLength(), worldTime, partialTicks);
        }
        return super.func_76563_a(worldTime, partialTicks);
    }

    public boolean func_186056_c(int x, int z) {
        return !this.field_76579_a.func_72916_c(x, z) || !this.func_186058_p().shouldLoadSpawn();
    }

    public void setAllowedSpawnTypes(boolean allowHostileIn, boolean allowPeacefulIn) {
        boolean allowHostile = this.field_76579_a.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL;
        boolean allowPeaceful = allowPeacefulIn;
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(this.getDimension());
        if (props != null) {
            Boolean hostiles = props.canSpawnHostiles();
            Boolean peaceful = props.canSpawnPeacefulMobs();
            if (hostiles != null) {
                allowHostile = hostiles;
            }
            if (peaceful != null) {
                allowPeaceful = peaceful;
            }
        }
        super.setAllowedSpawnTypes(allowHostile, allowPeaceful);
    }

    public boolean func_76566_a(int x, int z) {
        Boolean ignore = this.properties.ignoreSpawnSuitability();
        if (ignore != null && ignore.booleanValue()) {
            return true;
        }
        return super.func_76566_a(x, z);
    }

    public boolean canDoLightning(Chunk chunk) {
        return this.properties.canDoLightning() != null ? this.properties.canDoLightning() : false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.properties.canDoRainSnowIce() != null ? this.properties.canDoRainSnowIce() : false;
    }

    public boolean canBlockFreeze(BlockPos pos, boolean noWaterAdj) {
        if (this.properties.canDoRainSnowIce() != null) {
            return this.properties.canDoRainSnowIce() != false && WorldUtils.canBlockFreeze(this.field_76579_a, pos, noWaterAdj);
        }
        return super.canBlockFreeze(pos, noWaterAdj);
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        if (this.properties.canDoRainSnowIce() != null) {
            return this.properties.canDoRainSnowIce() != false && WorldUtils.canSnowAt(this.field_76579_a, pos);
        }
        return super.canSnowAt(pos, checkLight);
    }

    public boolean func_76568_b(int x, int z) {
        return this.properties.getHasXZFog() != null ? this.properties.getHasXZFog().booleanValue() : super.func_76568_b(x, z);
    }

    public boolean func_76569_d() {
        return this.properties.isSurfaceWorld() != null ? this.properties.isSurfaceWorld() : false;
    }

    public int func_76557_i() {
        return this.properties.getAverageGroundLevel() != null ? this.properties.getAverageGroundLevel().intValue() : super.func_76557_i();
    }

    public double getHorizon() {
        return this.properties.getHorizon() != null ? this.properties.getHorizon().doubleValue() : super.getHorizon();
    }

    public double getMovementFactor() {
        return this.properties.getMovementFactor() != null ? this.properties.getMovementFactor() : 1.0;
    }

    public float getSunBrightness(float partialTicks) {
        return this.properties.getSunBrightness() != null ? this.properties.getSunBrightness().floatValue() : super.getSunBrightness(partialTicks);
    }

    public float getSunBrightnessFactor(float partialTicks) {
        return this.properties.getSunBrightnessFactor() != null ? this.properties.getSunBrightnessFactor().floatValue() : super.getSunBrightnessFactor(partialTicks);
    }

    public boolean shouldClientCheckLighting() {
        if (this.properties.shouldClientCheckLight() != null) {
            return this.properties.shouldClientCheckLight();
        }
        return true;
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return !this.func_76569_d();
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public MusicTicker.MusicType getMusicType() {
        MusicTicker.MusicType music = ClientUtils.getMusicTypeFromProperties(this.properties);
        return music != null ? music : null;
    }

    public boolean func_76561_g() {
        return this.properties.getSkyColor() != null;
    }

    public float func_76571_f() {
        return this.properties.getCloudHeight();
    }

    public Vec3d getSkyColor(Entity entity, float partialTicks) {
        Vec3d skyColor = this.properties.getSkyColor();
        if (skyColor == null) {
            return super.getSkyColor(entity, partialTicks);
        }
        float f1 = MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(x, y, z);
        int blendColour = ForgeHooksClient.getSkyBlendColour((World)this.field_76579_a, (BlockPos)blockpos);
        float r = (float)((double)((float)(blendColour >> 16 & 0xFF) / 255.0f) * skyColor.field_72450_a);
        float g = (float)((double)((float)(blendColour >> 8 & 0xFF) / 255.0f) * skyColor.field_72448_b);
        float b = (float)((double)((float)(blendColour & 0xFF) / 255.0f) * skyColor.field_72449_c);
        return new Vec3d((double)(r *= f1), (double)(g *= f1), (double)(b *= f1));
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Vec3d fogColor = this.properties.getFogColor();
        if (fogColor == null) {
            return super.func_76562_b(celestialAngle, partialTicks);
        }
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float r = (float)fogColor.field_72450_a;
        float g = (float)fogColor.field_72448_b;
        float b = (float)fogColor.field_72449_c;
        return new Vec3d((double)(r *= f * 0.94f + 0.06f), (double)(g *= f * 0.94f + 0.06f), (double)(b *= f * 0.91f + 0.09f));
    }

    public Vec3d getCloudColor(float partialTicks) {
        Vec3d cloudColor = this.properties.getCloudColor();
        return cloudColor != null ? cloudColor : super.getCloudColor(partialTicks);
    }
}

