/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util.world;

import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.CommandTeleportJED;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class VoidTeleport {
    public static void tryVoidTeleportEntities(World world, @Nullable VoidTeleportData voidTeleport, @Nullable VoidTeleportData skyTeleport) {
        if (voidTeleport != null || skyTeleport != null) {
            MinecraftServer server = world.func_73046_m();
            for (int i = 0; i < world.field_72996_f.size(); ++i) {
                Entity entity = (Entity)world.field_72996_f.get(i);
                if (voidTeleport != null && entity.field_70163_u < voidTeleport.getTriggerY()) {
                    VoidTeleport.tryVoidTeleportEntity(entity, voidTeleport, server);
                    continue;
                }
                if (skyTeleport == null || !(entity.field_70163_u > skyTeleport.getTriggerY())) continue;
                VoidTeleport.tryVoidTeleportEntity(entity, skyTeleport, server);
            }
        }
    }

    private static void tryVoidTeleportEntity(Entity entity, VoidTeleportData voidTeleport, MinecraftServer server) {
        int originalDimension = entity.func_130014_f_().field_73011_w.getDimension();
        try {
            CommandTeleportJED.TeleportData data = voidTeleport.getTeleportDataFor(entity, server);
            if (data != null) {
                if (voidTeleport.getRemoveFallDamage()) {
                    entity.field_70143_R = 0.0f;
                } else {
                    float fallDistance;
                    float f = fallDistance = voidTeleport.getFallDistance() >= 0.0f ? voidTeleport.getFallDistance() : entity.field_70143_R;
                    if (entity instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)entity;
                        float minHealth = voidTeleport.getMinimumHealthLeft();
                        if (minHealth >= 0.0f) {
                            fallDistance = Math.min(fallDistance, living.func_110143_aJ() - minHealth + 3.0f);
                        }
                    }
                    if (fallDistance >= 0.0f) {
                        entity.field_70143_R = fallDistance;
                    }
                }
                CommandTeleportJED.instance().teleportEntityToLocation(entity, data, server);
            }
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Failed to \"void teleport\" entity '{}' (@ {}) from dimension '{}'", (Object)entity.func_70005_c_(), (Object)entity.func_174791_d(), (Object)originalDimension);
        }
    }

    public static enum TeleportType {
        SAME_LOCATION,
        OFFSET_LOCATION,
        SCALED_LOCATION,
        FIXED_LOCATION,
        RELATIVE_LOCATION,
        SPAWN;


        public static TeleportType fromName(String name) {
            for (TeleportType type : TeleportType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            JustEnoughDimensions.logger.warn("Invalid TeleportType name: '{}'", (Object)name);
            return SAME_LOCATION;
        }
    }

    public static class VoidTeleportData {
        private final TeleportType type;
        private final int destDimension;
        private double triggerY = -10.0;
        private float fallDistance = -1.0f;
        private float minHealthLeft = -1.0f;
        @Nullable
        private Vec3d scale;
        @Nullable
        private Vec3d offset;
        @Nullable
        private Vec3d targetPosition;
        @Nullable
        private String[] relativePositionArgs;
        private boolean findSurface;
        private boolean removeFallDamage;

        private VoidTeleportData(TeleportType type, int destDimension) {
            this.type = type;
            this.destDimension = destDimension;
        }

        public double getTriggerY() {
            return this.triggerY;
        }

        public int getDestinationDimension() {
            return this.destDimension;
        }

        public boolean getRemoveFallDamage() {
            return this.removeFallDamage;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }

        public float getMinimumHealthLeft() {
            return this.minHealthLeft;
        }

        public Vec3d getTargetPosition(Vec3d originalPosition, WorldServer targetWorld) {
            Vec3d newPos = originalPosition;
            switch (this.type) {
                case SAME_LOCATION: {
                    break;
                }
                case OFFSET_LOCATION: {
                    newPos = originalPosition.func_178787_e(this.offset);
                    break;
                }
                case SCALED_LOCATION: {
                    newPos = new Vec3d(originalPosition.field_72450_a * this.scale.field_72450_a, originalPosition.field_72448_b * this.scale.field_72448_b, originalPosition.field_72449_c * this.scale.field_72449_c);
                    break;
                }
                case FIXED_LOCATION: {
                    newPos = this.targetPosition;
                    break;
                }
                case RELATIVE_LOCATION: {
                    newPos = this.parseCoordinate(originalPosition);
                    break;
                }
                case SPAWN: {
                    BlockPos spawn = WorldUtils.getWorldSpawn(targetWorld);
                    newPos = new Vec3d((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5);
                }
            }
            if (this.findSurface) {
                BlockPos pos = new BlockPos(newPos);
                pos = WorldUtils.getSuitableSpawnBlockInColumn((World)targetWorld, pos, true);
                newPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            return newPos;
        }

        private void setTriggerY(double triggerY) {
            this.triggerY = triggerY;
        }

        private void setScale(Vec3d scale) {
            this.scale = scale;
        }

        private void setOffset(Vec3d offset) {
            this.offset = offset;
        }

        private void setTargetPosition(Vec3d position) {
            this.targetPosition = position;
        }

        private void setRelativePosition(String arg) {
            String[] parts = arg.split(" ");
            if (parts.length != 3) {
                JustEnoughDimensions.logger.warn("VoidTeleportData: Invalid relative position argument '{}'", (Object)arg);
                parts = "~ ~ ~".split(" ");
            }
            this.relativePositionArgs = parts;
        }

        private Vec3d parseCoordinate(Vec3d posBase) {
            try {
                double x = CommandBase.func_175770_a((double)posBase.field_72450_a, (String)this.relativePositionArgs[0], (boolean)false).func_179628_a();
                double y = CommandBase.func_175770_a((double)posBase.field_72448_b, (String)this.relativePositionArgs[1], (boolean)false).func_179628_a();
                double z = CommandBase.func_175770_a((double)posBase.field_72449_c, (String)this.relativePositionArgs[2], (boolean)false).func_179628_a();
                return new Vec3d(x, y, z);
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("VoidTeleportData.parseCoordinate(): Failed to calculate the relative coordinate");
                return posBase;
            }
        }

        @Nullable
        public CommandTeleportJED.TeleportData getTeleportDataFor(Entity entity, MinecraftServer server) {
            WorldServer world = server.func_71218_a(this.destDimension);
            if (world != null) {
                Vec3d pos = this.getTargetPosition(entity.func_174791_d(), world);
                return new CommandTeleportJED.TeleportData(entity, this.destDimension, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            return null;
        }

        @Nullable
        public static VoidTeleportData fromJson(@Nullable JsonObject obj, int originalDimension) {
            if (obj != null) {
                try {
                    if (obj.has("dimension")) {
                        int dimension = obj.get("dimension").getAsInt();
                        TeleportType type = TeleportType.SAME_LOCATION;
                        if (obj.has("teleport_type")) {
                            type = TeleportType.fromName(obj.get("teleport_type").getAsString());
                        }
                        VoidTeleportData data = new VoidTeleportData(type, dimension);
                        if (obj.has("trigger_y")) {
                            data.setTriggerY(obj.get("trigger_y").getAsDouble());
                        }
                        data.findSurface = JEDJsonUtils.getBooleanOrDefault(obj, "find_surface", false);
                        data.removeFallDamage = JEDJsonUtils.getBooleanOrDefault(obj, "remove_fall_damage", false);
                        data.fallDistance = JEDJsonUtils.getFloatOrDefault(obj, "fall_distance", -1.0f);
                        data.minHealthLeft = JEDJsonUtils.getFloatOrDefault(obj, "min_health_left", -1.0f);
                        if (type == TeleportType.SCALED_LOCATION) {
                            data.setScale(JEDJsonUtils.getVec3dOrDefault(obj, "scale", new Vec3d(1.0, 1.0, 1.0)));
                        } else if (type == TeleportType.OFFSET_LOCATION) {
                            data.setOffset(JEDJsonUtils.getVec3dOrDefault(obj, "offset", new Vec3d(0.0, 128.0, 0.0)));
                        } else if (type == TeleportType.FIXED_LOCATION) {
                            if (JEDJsonUtils.hasArray(obj, "target_position")) {
                                data.setTargetPosition(JEDJsonUtils.getVec3dOrDefault(obj, "target_position", new Vec3d(0.0, 64.0, 0.0)));
                            } else {
                                data.setTargetPosition(JEDJsonUtils.getVec3dOrDefault(obj, "fixed_location", new Vec3d(0.0, 64.0, 0.0)));
                            }
                        } else if (type == TeleportType.RELATIVE_LOCATION) {
                            data.setRelativePosition(JEDJsonUtils.getStringOrDefault(obj, "relative_location", "", true));
                        }
                        return data;
                    }
                }
                catch (Exception e) {
                    JustEnoughDimensions.logger.warn("Invalid or incomplete VoidTeleportData for dimension '{}'", (Object)originalDimension);
                }
            }
            return null;
        }
    }
}

