/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import java.text.NumberFormat;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SmeltingUtils {
    public static final int FUEL_TIME = 1600;
    public static final int SMELT_TIME = 100;
    public static final String TAG_SMELTLIST = "RFC_smeltList";
    public static final String TAG_SMELTJOB = "RFC_smeltingJob";
    public static final String TAG_FUELTIME = "RFC_fuelTime";

    public static boolean canSmelt(TileEntityRFC tile) {
        return UpgradeHelper.getUpgrade(tile, StringLibs.TAG_SMELT) != null;
    }

    public static void createSmeltingJob(TileEntityRFC tile) {
        int toSmelt = -1;
        int smeltResult = -1;
        block0: for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
            ItemStack result;
            if (SmeltingUtils.hasSmeltingJob(tile, i) || tile.getInventory().getTrueStackInSlot(i).func_77973_b() == RFCItems.dyedFolder || (result = FurnaceRecipes.func_77602_a().func_151395_a(tile.getInventory().getStackInSlot(i))).func_190926_b()) continue;
            toSmelt = i;
            for (int j = 0; j < tile.getInventory().getSlots(); ++j) {
                ItemStack loopStack = tile.getInventory().getStackFromFolder(j);
                if (loopStack.func_190926_b()) continue;
                if (!ItemStack.func_179545_c((ItemStack)loopStack, (ItemStack)result) || toSmelt == j) continue;
                smeltResult = j;
                continue block0;
            }
        }
        if (toSmelt >= 0 && smeltResult >= 0) {
            SmeltingUtils.addSmeltingJob(tile, toSmelt, smeltResult);
        }
        if (!tile.smeltingJobs.isEmpty() && tile.fuelTime <= 0) {
            for (int k = 0; k < tile.getInventory().getSlots(); ++k) {
                ItemStack fuel = tile.getInventory().getStackInSlot(k);
                if (fuel.func_190926_b() || fuel.func_77973_b() != Items.field_151044_h) continue;
                ItemFolder.remove(tile.getInventory().getTrueStackInSlot(k), 1L);
                tile.fuelTime = 1600;
                break;
            }
        }
    }

    public static void writeSmeltNBT(TileEntityRFC tile, NBTTagCompound tag) {
        if (!SmeltingUtils.canSmelt(tile)) {
            if (!tile.smeltingJobs.isEmpty()) {
                tile.smeltingJobs.clear();
            }
            tile.fuelTime = 0;
            return;
        }
        tag.func_74768_a(TAG_FUELTIME, tile.fuelTime);
        NBTTagList tagList = new NBTTagList();
        for (int[] job : tile.smeltingJobs) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a(TAG_SMELTJOB, job);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a(TAG_SMELTLIST, (NBTBase)tagList);
    }

    public static void readSmeltNBT(TileEntityRFC tile, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_SMELTLIST)) {
            NBTTagList tagList = tag.func_150295_c(TAG_SMELTLIST, 11);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int[] job = tagList.func_150306_c(i);
                tile.smeltingJobs.add(job);
            }
        }
        tile.fuelTime = tag.func_74762_e(TAG_FUELTIME);
    }

    private static void addSmeltingJob(TileEntityRFC tile, int toSmelt, int smeltResult) {
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        int[] job = new int[]{0, toSmelt, smeltResult};
        tile.smeltingJobs.add(job);
    }

    private static boolean hasSmeltingJob(TileEntityRFC tile, int toSmeltSlot) {
        for (int[] job : tile.smeltingJobs) {
            if (job[1] != toSmeltSlot) continue;
            return true;
        }
        return false;
    }

    private static void completeSmeltingJob(TileEntityRFC tile, int[] job, int jobIndex) {
        if (tile.getInventory().getStackInSlot(job[1]).func_190926_b()) {
            tile.smeltingJobs.remove(jobIndex);
            return;
        }
        ItemFolder.remove(tile.getInventory().getTrueStackInSlot(job[1]), 1L);
        ItemFolder.add(tile.getInventory().getTrueStackInSlot(job[2]), 1L);
        if (tile.getInventory().getStackInSlot(job[1]).func_190926_b()) {
            tile.smeltingJobs.remove(jobIndex);
            return;
        }
        job[0] = 0;
    }

    public static void incrementSmeltTime(TileEntityRFC tile) {
        if (tile.fuelTime > 0) {
            --tile.fuelTime;
        } else {
            return;
        }
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (!tile.smeltingJobs.isEmpty()) {
            for (int i = 0; i < tile.smeltingJobs.size(); ++i) {
                int[] job = tile.smeltingJobs.get(i);
                job[0] = job[0] + 1;
                if (job[0] < 100) continue;
                SmeltingUtils.completeSmeltingJob(tile, job, i);
            }
        }
    }

    public static String getSmeltingPercentage(TileEntityRFC tile, int slot) {
        if (UpgradeHelper.getUpgrade(tile, StringLibs.TAG_SMELT) == null || tile.smeltingJobs.isEmpty()) {
            return "";
        }
        for (int[] job : tile.smeltingJobs) {
            if (job[1] != slot) continue;
            NumberFormat percentFormatter = NumberFormat.getInstance();
            double calc = 0.0;
            if (job[0] > 0) {
                calc = (double)job[0] / 100.0;
            }
            return " [" + percentFormatter.format(calc *= 100.0) + "%]";
        }
        return "";
    }

    public static boolean isSmelting(TileEntityRFC tile) {
        return tile.fuelTime > 0;
    }
}

