/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;

public class FluidUtils {
    public static boolean doPlace(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        if (!NBTUtils.getBoolean(stack, StringLibs.RFC_PLACEMODE, false)) {
            return false;
        }
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, pos, facing)) {
            return false;
        }
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return false;
        }
        long count = ItemFolder.getFileSize(stack);
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        if (cap.isFluidStack() && count >= 1000L) {
            pos = pos.func_177972_a(facing);
            Block hitblock = world.func_180495_p(pos).func_177230_c();
            Fluid fluid = cap.getFluidStack().getFluid();
            int l = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
            if (!hitblock.func_176200_f((IBlockAccess)world, pos)) {
                return false;
            }
            if (fluid != null && (hitblock != fluid.getBlock() || hitblock == fluid.getBlock() && l != 0)) {
                if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    ItemFolder.remove(stack, 1000L);
                }
                world.func_180501_a(pos, fluid.getBlock().func_176223_P(), 3);
                return true;
            }
        }
        return false;
    }

    public static boolean doDrain(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        if (NBTUtils.getBoolean(stack, StringLibs.RFC_PLACEMODE, false)) {
            return false;
        }
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, pos, facing)) {
            return false;
        }
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        int l = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        if (block instanceof BlockLiquid && l == 0) {
            if (ItemFolder.getObject(stack) != null && cap.isFluidStack() && cap.getFluidStack().getFluid().getBlock() == block) {
                if (!world.field_72995_K) {
                    ItemFolder.add(stack, 1000L);
                    world.func_175698_g(pos);
                }
                return true;
            }
        } else if (block instanceof IFluidBlock && l == 0) {
            Fluid fluid = ((IFluidBlock)block).getFluid();
            if (ItemFolder.getObject(stack) != null && cap.isFluidStack() && cap.getFluidStack().getFluid() == fluid) {
                if (!world.field_72995_K) {
                    ItemFolder.add(stack, 1000L);
                    world.func_175698_g(pos);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canAcceptFluidContainer(ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack) != null;
    }

    public static FluidStack getFluidFromFolder(TileEntityRFC tile, int slot) {
        ItemStack stack = tile.getInventory().getTrueStackInSlot(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() == RFCItems.folder && stack.func_77952_i() == 4 && stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
            int count = (int)Math.min(Integer.MAX_VALUE, ItemFolder.getFileSize(stack));
            FluidStack fluid = cap.getFluidStack();
            fluid.amount = count;
            return fluid;
        }
        return null;
    }
}

