/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EnderUtils {
    public static void syncToFolder(TileEntityRFC tile, ItemStack stack, int index) {
        ItemStack folder = tile.getInventory().getTrueStackInSlot(index);
        long folderSize = ItemFolder.getFileSize(folder);
        if (folderSize != ItemFolder.getFileSize(stack) && EnderUtils.hashMatches(stack, tile)) {
            ItemFolder.setFileSize(stack, folderSize);
            return;
        }
        if (!EnderUtils.hashMatches(stack, tile)) {
            ItemFolder.setFileSize(stack, 0L);
        }
    }

    public static void syncToTile(TileEntityRFC tile, int dim, int index, int amount, boolean subtract) {
        if (tile == null || UpgradeHelper.getUpgrade(tile, StringLibs.TAG_ENDER) == null) {
            return;
        }
        ItemStack folder = tile.getInventory().getTrueStackInSlot(index);
        if (folder.func_77973_b() != RFCItems.folder) {
            return;
        }
        if (!subtract) {
            ItemFolder.add(folder, amount);
        } else {
            ItemFolder.remove(folder, amount);
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
    }

    public static ItemStack createEnderFolder(TileEntityRFC tile, EntityPlayer player, ItemStack stack) {
        NBTTagCompound playerTag = player.getEntityData();
        if (!playerTag.func_74764_b(StringLibs.RFC_SLOTINDEX)) {
            playerTag.func_74768_a(StringLibs.RFC_SLOTINDEX, 0);
        }
        ItemStack enderFolder = stack.func_77946_l();
        enderFolder.func_77964_b(1);
        NBTUtils.setInt(enderFolder, StringLibs.RFC_SLOTINDEX, playerTag.func_74762_e(StringLibs.RFC_SLOTINDEX));
        NBTUtils.setInt(enderFolder, StringLibs.RFC_HASH, tile.getHash(tile));
        EnderUtils.setTileLoc(tile, enderFolder);
        return enderFolder;
    }

    public static void setTileLoc(TileEntityRFC tile, ItemStack stack) {
        BlockPos pos = tile.func_174877_v();
        int dim = tile.func_145831_w().field_73011_w.getDimension();
        NBTUtils.setCompound(stack, StringLibs.RFC_TILEPOS, new NBTTagCompound());
        NBTTagCompound posTag = NBTUtils.getCompound(stack, StringLibs.RFC_TILEPOS, true);
        posTag.func_74768_a("X", pos.func_177958_n());
        posTag.func_74768_a("Y", pos.func_177956_o());
        posTag.func_74768_a("Z", pos.func_177952_p());
        NBTUtils.setInt(stack, StringLibs.RFC_DIM, dim);
    }

    public static TileEntityRFC getTileLoc(ItemStack stack) {
        NBTTagCompound posTag = NBTUtils.getCompound(stack, StringLibs.RFC_TILEPOS, true);
        if (posTag != null) {
            int x = posTag.func_74762_e("X");
            int y = posTag.func_74762_e("Y");
            int z = posTag.func_74762_e("Z");
            int dim = NBTUtils.getInt(stack, StringLibs.RFC_DIM, 0);
            return EnderUtils.findLoadedTileEntityInWorld(new BlockPos(x, y, z), dim);
        }
        return null;
    }

    public static TileEntityRFC findLoadedTileEntityInWorld(BlockPos pos, int dim) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        if (pos.func_177956_o() == -1) {
            return null;
        }
        for (WorldServer world : server.field_71305_c) {
            for (Object obj : world.field_147482_g) {
                if (!(obj instanceof TileEntityRFC) || world.field_73011_w.getDimension() != dim || !pos.equals((Object)((TileEntityRFC)obj).func_174877_v()) || UpgradeHelper.getUpgrade((TileEntityRFC)obj, StringLibs.TAG_ENDER) == null || !world.func_175667_e(pos)) continue;
                return (TileEntityRFC)world.func_175625_s(pos);
            }
        }
        return null;
    }

    public static void extractEnderFolder(TileEntityRFC tile, EntityPlayer player) {
        NBTTagCompound playerTag = player.getEntityData();
        if (playerTag.func_74764_b(StringLibs.RFC_SLOTINDEX)) {
            int index = playerTag.func_74762_e(StringLibs.RFC_SLOTINDEX);
            ItemStack folder = tile.getInventory().getTrueStackInSlot(index);
            if (folder == ItemStack.field_190927_a) {
                if (EnderUtils.findNextFolder(tile, index) == -1) {
                    folder = tile.getInventory().getTrueStackInSlot(0);
                    playerTag.func_74768_a(StringLibs.RFC_SLOTINDEX, 0);
                    index = 0;
                }
                index = EnderUtils.findNextFolder(tile, index);
                folder = tile.getInventory().getTrueStackInSlot(index);
                if (folder == ItemStack.field_190927_a) {
                    return;
                }
                playerTag.func_74768_a(StringLibs.RFC_SLOTINDEX, index);
            }
            ItemStack newFolder = EnderUtils.createEnderFolder(tile, player, folder);
            player.func_184611_a(EnumHand.MAIN_HAND, newFolder);
            playerTag.func_74768_a(StringLibs.RFC_SLOTINDEX, ++index);
        } else {
            for (int i = 0; i < tile.getInventory().getSlots(); ++i) {
                ItemStack folder = tile.getInventory().getTrueStackInSlot(i);
                if (folder == ItemStack.field_190927_a) continue;
                ItemStack newFolder = EnderUtils.createEnderFolder(tile, player, folder);
                player.func_184611_a(EnumHand.MAIN_HAND, newFolder);
                break;
            }
        }
    }

    private static int findNextFolder(TileEntityRFC tile, int slot) {
        int index = 0;
        for (int i = slot; i < tile.getInventory().getSlots(); ++i) {
            ItemStack stack = tile.getInventory().getStackInSlot(i);
            if (stack == ItemStack.field_190927_a) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int createHash(TileEntityRFC tile) {
        String tilepos = Long.toString(tile.func_174877_v().func_177986_g());
        String worldtime = Long.toString(tile.func_145831_w().func_82737_E());
        String str = new String(tilepos + worldtime);
        return str.hashCode();
    }

    private static boolean hashMatches(ItemStack stack, TileEntityRFC tile) {
        return NBTUtils.getInt(stack, StringLibs.RFC_HASH, -1) == tile.getHash(tile);
    }

    public static boolean preValidateEnderFolder(ItemStack stack) {
        TileEntityRFC tile = EnderUtils.getTileLoc(stack);
        if (tile == null) {
            return false;
        }
        return tile == null || EnderUtils.hashMatches(stack, tile);
    }
}

