/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.integration.BotaniaRFC;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;

public class ItemManaFolder
extends Item
implements IFolder,
IManaItem,
IManaTooltipDisplay {
    private static final String TAG_MANA_COUNT = "manaCount";
    private static final String TAG_MAX_MANA_COUNT = "maxManaCount";
    private static final int maxCount = 1000000000;

    public ItemManaFolder() {
        this.setRegistryName("folder_mana");
        this.func_77655_b("realfilingcabinet.manafolder");
        this.func_77625_d(1);
        this.func_77637_a(TabRFC.instance);
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag whatisthis) {
        int count = ItemManaFolder.getManaSize(stack);
        list.add(BotaniaRFC.formatMana(count));
    }

    public static void setManaSize(ItemStack stack, int count) {
        NBTUtils.setInt(stack, TAG_MANA_COUNT, Math.max(0, count));
    }

    public static int getManaSize(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_MANA_COUNT, 0);
    }

    public static void addManaToFolder(ItemStack stack, int count) {
        int current = ItemManaFolder.getManaSize(stack);
        ItemManaFolder.setManaSize(stack, current + count);
    }

    public static boolean isManaFolderFull(ItemStack stack) {
        return ItemManaFolder.getManaSize(stack) >= 1000000000;
    }

    public static int getMaxManaFolder() {
        return 1000000000;
    }

    public void addMana(ItemStack stack, int count) {
        ItemManaFolder.addManaToFolder(stack, count);
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherstack) {
        return true;
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherstack) {
        return true;
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return ItemManaFolder.getManaSize(stack);
    }

    public int getMaxMana(ItemStack stack) {
        return ItemManaFolder.getMaxManaFolder();
    }

    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)ItemManaFolder.getManaSize(stack) / (float)this.getMaxMana(stack);
    }

    @Override
    public ItemStack isFolderEmpty(ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldstack, ItemStack newstack, boolean slotchanged) {
        return oldstack.func_77973_b() != newstack.func_77973_b();
    }
}

