/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.LogRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.FluidUtils;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;

public class ItemFolder
extends Item
implements IFolder {
    public static int extractSize = 0;

    public ItemFolder() {
        this.setRegistryName("folder");
        this.func_77655_b("realfilingcabinet.folder");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return super.getNBTShareTag(stack);
        }
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p().func_74737_b() : new NBTTagCompound();
        tag.func_74782_a("folderCap", (NBTBase)((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).serializeNBT());
        LogRFC.debug("Sharing tag: " + tag.toString());
        return tag;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + FolderType.values()[stack.func_77952_i()].toString().toLowerCase();
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).addTooltips(player, list, whatisthis);
        }
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ItemStack.field_190927_a;
        }
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        long count = cap.getCount();
        long extract = 0L;
        if (count > 0L && cap.isItemStack()) {
            extract = Math.min((long)cap.getItemStack().func_77976_d(), count);
        }
        if (NBTUtils.getBoolean(stack, StringLibs.RFC_TAPED, false)) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        if (stack.func_77952_i() == FolderType.DURA.ordinal() && count == 0L) {
            ItemFolder.setRemSize(copy, 0);
        }
        ItemFolder.remove(copy, extract);
        extractSize = (int)extract;
        return copy;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    public static String getFolderDisplayName(ItemStack stack) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getDisplayName();
        }
        return "";
    }

    public static int getFileMeta(ItemStack stack) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
            if (cap.isFluidStack()) {
                return cap.getItemStack().func_77952_i();
            }
            if (cap.isBlock()) {
                return cap.getBlock().func_177230_c().func_176201_c(cap.getBlock());
            }
        }
        return 0;
    }

    public static void setFileMeta(ItemStack stack, int meta) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
            if (cap.isFluidStack()) {
                cap.getItemStack().func_77964_b(meta);
            } else if (cap.isBlock()) {
                cap.setContents(cap.getBlock().func_177230_c().func_176201_c(cap.getBlock()));
            }
        }
    }

    public static void setFileSize(ItemStack stack, long count) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).setCount(count);
        }
    }

    public static long getFileSize(ItemStack stack) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getCount();
        }
        return 0L;
    }

    public static void remove(ItemStack stack, long count) {
        long current = ItemFolder.getFileSize(stack);
        ItemFolder.setFileSize(stack, Math.max(current - count, 0L));
    }

    public static ItemStack insert(ItemStack folder, ItemStack items, boolean simulate) {
        if (folder.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).insertItems(items, simulate);
        }
        return items;
    }

    @Deprecated
    public static void add(ItemStack stack, long count) {
        long current = ItemFolder.getFileSize(stack);
        ItemFolder.setFileSize(stack, current + count);
    }

    public static void setRemSize(ItemStack stack, int count) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).setRemaining(count);
        }
    }

    public static int getRemSize(ItemStack stack) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getRemaining();
        }
        return 0;
    }

    public static void addRem(ItemStack stack, int count) {
        int current = ItemFolder.getRemSize(stack);
        ItemFolder.setRemSize(stack, current + count);
    }

    public static void remRem(ItemStack stack, int count) {
        int current = ItemFolder.getRemSize(stack);
        ItemFolder.setRemSize(stack, Math.max(current - count, 0));
    }

    public static NBTTagCompound getItemTag(ItemStack stack) {
        CapabilityFolder cap;
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null) && (cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).isItemStack()) {
            return cap.getItemStack().func_77978_p();
        }
        return new NBTTagCompound();
    }

    public static void setItemTag(ItemStack stack, NBTTagCompound tag) {
        CapabilityFolder cap;
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null) && (cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).isItemStack()) {
            cap.getItemStack().func_77982_d(tag);
        }
    }

    public static Object getObject(ItemStack folder) {
        if (folder.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getContents();
        }
        return null;
    }

    public static boolean setObject(ItemStack folder, Object object) {
        if (folder.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null) && ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getContents() == null) {
            return ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).setContents(object);
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemFolder.getObject(stack) != null) {
            if (stack.func_77952_i() < 2 && ((ItemStack)ItemFolder.getObject(stack)).func_77973_b() instanceof ItemBlock) {
                long count = ItemFolder.getFileSize(stack);
                if (stack.func_77952_i() == FolderType.ENDER.ordinal() && !EnderUtils.preValidateEnderFolder(stack)) {
                    return EnumActionResult.FAIL;
                }
                if (count > 0L) {
                    ItemStack stackToPlace = new ItemStack(((ItemStack)ItemFolder.getObject(stack)).func_77973_b(), 1, ((ItemStack)ItemFolder.getObject(stack)).func_77952_i());
                    ItemStack savedfolder = player.func_184586_b(hand);
                    player.func_184611_a(hand, stackToPlace);
                    EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
                    player.func_184611_a(hand, savedfolder);
                    if (ear == EnumActionResult.SUCCESS) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (stack.func_77952_i() == FolderType.ENDER.ordinal() && !world.field_72995_K) {
                                EnderUtils.syncToTile(EnderUtils.getTileLoc(stack), NBTUtils.getInt(stack, StringLibs.RFC_DIM, 0), NBTUtils.getInt(stack, StringLibs.RFC_SLOTINDEX, 0), 1, true);
                                if (player instanceof FakePlayer) {
                                    EnderUtils.syncToFolder(EnderUtils.getTileLoc(stack), stack, NBTUtils.getInt(stack, StringLibs.RFC_SLOTINDEX, 0));
                                }
                            } else {
                                ItemFolder.remove(stack, 1L);
                            }
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            if (stack.func_77952_i() == 3 && MobUtils.spawnEntityFromFolder(world, player, stack, pos, side)) {
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_77952_i() == 4) {
                if (!(ItemFolder.getObject(stack) instanceof FluidStack)) {
                    return EnumActionResult.PASS;
                }
                if (FluidUtils.doPlace(world, player, stack, pos, side)) {
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos pos;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() != this) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77952_i() == FolderType.DURA.ordinal()) {
            NBTTagCompound tag;
            tag.func_74757_a(StringLibs.RFC_IGNORENBT, !(tag = stack.func_77978_p()).func_74767_n(StringLibs.RFC_IGNORENBT));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!stack.func_190926_b() && stack.func_77952_i() != FolderType.FLUID.ordinal()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult rtr = this.func_77621_a(world, player, true);
        if (rtr == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, rtr.func_178782_a(), rtr.field_178784_b)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && FluidUtils.doDrain(world, player, stack, pos = rtr.func_178782_a(), rtr.field_178784_b)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer && entityLiving.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() == this && stack.func_77952_i() == 4) {
            NBTTagCompound tag;
            tag.func_74757_a(StringLibs.RFC_PLACEMODE, !(tag = stack.func_77978_p()).func_74767_n(StringLibs.RFC_PLACEMODE));
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null) && stack.func_77942_o() && stack.func_77978_p().func_150297_b("folderCap", 10))) {
            return;
        }
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        LogRFC.debug("Deserializing: " + stack.func_77978_p().func_74775_l("folderCap").toString());
        cap.deserializeNBT(stack.func_77978_p().func_74775_l("folderCap"));
        stack.func_77978_p().func_82580_o("folderCap");
        if (stack.func_77978_p().func_186856_d() <= 0) {
            stack.func_77982_d(null);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldstack, ItemStack newstack, boolean slotchanged) {
        return oldstack.func_77973_b() != newstack.func_77973_b() || oldstack.func_77973_b() == newstack.func_77973_b() && oldstack.func_77952_i() != newstack.func_77952_i();
    }

    @Override
    public ItemStack isFolderEmpty(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: {
                return new ItemStack((Item)RFCItems.emptyFolder, 1, 0);
            }
            case 2: {
                return new ItemStack((Item)RFCItems.emptyFolder, 1, 1);
            }
            case 3: {
                return new ItemStack((Item)RFCItems.emptyFolder, 1, 2);
            }
            case 4: {
                return new ItemStack((Item)RFCItems.emptyFolder, 1, 3);
            }
            case 5: {
                return new ItemStack((Item)RFCItems.emptyFolder, 1, 4);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static enum FolderType {
        NORMAL,
        ENDER,
        DURA,
        MOB,
        FLUID,
        NBT;

    }
}

