/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.LogRFC;
import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemDyedFolder
extends Item
implements IFolder {
    public ItemDyedFolder() {
        this.setRegistryName("dyedfolder");
        this.func_77655_b("realfilingcabinet.dyedfolder");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return super.getNBTShareTag(stack);
        }
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p().func_74737_b() : new NBTTagCompound();
        tag.func_74782_a("folderCap", (NBTBase)((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).serializeNBT());
        LogRFC.debug("Sharing tag: " + tag.toString());
        return tag;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + EnumDyeColor.values()[stack.func_77952_i()].func_176610_l().toLowerCase();
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        if (stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            ((CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).addTooltips(player, list, whatisthis);
        }
        list.add("Limit: " + NewConfigRFC.ConfigRFC.folderSizeLimit);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null)) {
            return ItemStack.field_190927_a;
        }
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        long count = cap.getCount();
        long extract = 0L;
        if (count > 0L && cap.isItemStack()) {
            extract = Math.min((long)cap.getItemStack().func_77976_d(), count);
        }
        if (NBTUtils.getBoolean(stack, StringLibs.RFC_TAPED, false)) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        ItemFolder.remove(copy, extract);
        return copy;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    public static int add(ItemStack stack, long count) {
        if (!(stack.func_77973_b() instanceof ItemDyedFolder)) {
            ItemFolder.add(stack, count);
            return Integer.MAX_VALUE;
        }
        long current = ItemFolder.getFileSize(stack);
        long newCount = Math.min(count + current, (long)NewConfigRFC.ConfigRFC.folderSizeLimit);
        long remainder = (long)NewConfigRFC.ConfigRFC.folderSizeLimit - ItemFolder.getFileSize(stack);
        ItemFolder.setFileSize(stack, newCount);
        return (int)remainder;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        long count;
        ItemStack stack = player.func_184586_b(hand);
        if (ItemFolder.getObject(stack) != null && ((ItemStack)ItemFolder.getObject(stack)).func_77973_b() instanceof ItemBlock && (count = ItemFolder.getFileSize(stack)) > 0L) {
            ItemStack stackToPlace = new ItemStack(((ItemStack)ItemFolder.getObject(stack)).func_77973_b(), 1, ((ItemStack)ItemFolder.getObject(stack)).func_77952_i());
            ItemStack savedfolder = player.func_184586_b(hand);
            player.func_184611_a(hand, stackToPlace);
            EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
            player.func_184611_a(hand, savedfolder);
            if (ear == EnumActionResult.SUCCESS) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemFolder.remove(stack, 1L);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(stack.hasCapability(CapabilityProviderFolder.FOLDER_CAP, null) && stack.func_77942_o() && stack.func_77978_p().func_150297_b("folderCap", 10))) {
            return;
        }
        CapabilityFolder cap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        LogRFC.debug("Deserializing: " + stack.func_77978_p().func_74775_l("folderCap").toString());
        cap.deserializeNBT(stack.func_77978_p().func_74775_l("folderCap"));
        stack.func_77978_p().func_82580_o("folderCap");
        if (stack.func_77978_p().func_186856_d() <= 0) {
            stack.func_77982_d(null);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldstack, ItemStack newstack, boolean slotchanged) {
        return oldstack.func_77973_b() != newstack.func_77973_b() || oldstack.func_77973_b() == newstack.func_77973_b() && oldstack.func_77952_i() != newstack.func_77952_i();
    }

    @Override
    public ItemStack isFolderEmpty(ItemStack stack) {
        return new ItemStack((Item)RFCItems.emptyDyedFolder, 1, stack.func_77952_i());
    }
}

