/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import thaumcraft.api.aspects.Aspect;

public class ItemAspectFolder
extends Item
implements IFolder {
    private static final String TAG_ASPECT = "RFC_aspectType";
    private static final String TAG_ASPECT_COUNT = "RFC_aspectCount";
    private static final int MAX_COUNT = 10000;

    public ItemAspectFolder() {
        this.setRegistryName("folder_aspect");
        this.func_77655_b("realfilingcabinet.aspectfolder");
        this.func_77625_d(1);
        this.func_77637_a(TabRFC.instance);
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag whatisthis) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TAG_ASPECT)) {
            Aspect asp = ItemAspectFolder.getAspectFromFolder(stack);
            int count = ItemAspectFolder.getAspectCount(stack);
            list.add(asp.getName() + " x" + count);
        } else {
            list.add("<Empty>");
        }
    }

    @Optional.Method(modid="thaumcraft")
    public static boolean isAspectFolderEmpty(ItemStack stack) {
        return !stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b(TAG_ASPECT);
    }

    @Optional.Method(modid="thaumcraft")
    public static Aspect getAspectFromFolder(ItemStack stack) {
        return Aspect.getAspect((String)NBTUtils.getString(stack, TAG_ASPECT, ""));
    }

    @Optional.Method(modid="thaumcraft")
    public static int getAspectCount(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_ASPECT_COUNT, 0);
    }

    @Optional.Method(modid="thaumcraft")
    public static void setAspect(ItemStack stack, Aspect asp) {
        NBTUtils.setString(stack, TAG_ASPECT, asp.getTag());
    }

    @Optional.Method(modid="thaumcraft")
    public static void setAspectCount(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, TAG_ASPECT_COUNT, amount);
    }

    @Optional.Method(modid="thaumcraft")
    public static void addAspect(ItemStack stack, int amount) {
        int current = ItemAspectFolder.getAspectCount(stack);
        ItemAspectFolder.setAspectCount(stack, current + amount);
    }

    @Optional.Method(modid="thaumcraft")
    public static void removeAspect(ItemStack stack, int amount) {
        int current = ItemAspectFolder.getAspectCount(stack);
        ItemAspectFolder.setAspectCount(stack, Math.max(current - amount, 0));
    }

    public static int getMaxAmount() {
        return 10000;
    }

    @Override
    public ItemStack isFolderEmpty(ItemStack stack) {
        if (ItemAspectFolder.getAspectCount(stack) == 0) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

