/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryEntity
extends ItemStackHandler {
    final EntityCabinet cabinet;

    public InventoryEntity(EntityCabinet cabinet, int size) {
        this.cabinet = cabinet;
        this.setSize(size);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack == null || stack.func_190916_E() == 0) {
            return null;
        }
        this.validateSlotIndex(slot);
        if (this.simpleFolderMatch(stack) != -1) {
            slot = this.simpleFolderMatch(stack);
            if (!simulate) {
                if (((ItemStack)this.getStacks().get(slot)).func_77973_b() == RFCItems.folder && ((ItemStack)this.getStacks().get(slot)).func_77952_i() == 2) {
                    int remSize = stack.func_77952_i();
                    int storedRem = ItemFolder.getRemSize((ItemStack)this.getStacks().get(slot));
                    if (remSize == 0) {
                        ItemFolder.insert((ItemStack)this.getStacks().get(slot), stack, simulate);
                    }
                    ItemFolder.addRem((ItemStack)this.getStacks().get(slot), stack.func_77958_k() - stack.func_77952_i());
                    int newRem = ItemFolder.getRemSize((ItemStack)this.getStacks().get(slot));
                    if (newRem >= stack.func_77958_k()) {
                        ItemFolder.insert((ItemStack)this.getStacks().get(slot), stack, simulate);
                        int newStoredRem = newRem - stack.func_77958_k();
                        ItemFolder.setRemSize((ItemStack)this.getStacks().get(slot), newStoredRem);
                    }
                } else {
                    ItemFolder.insert((ItemStack)this.stacks.get(slot), stack, simulate);
                }
            }
            return null;
        }
        return stack;
    }

    public ItemStack getStackFromFolder(int slot) {
        ItemStack stack;
        ItemStack folder = this.getStackInSlot(slot);
        if (ItemFolder.getObject(folder) == null) {
            return ItemStack.field_190927_a;
        }
        if (folder != null && folder.func_77973_b() instanceof IFolder && ItemFolder.getObject(folder) instanceof ItemStack && !(stack = (ItemStack)ItemFolder.getObject(folder)).func_190926_b()) {
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean canInsertItem(ItemStack stack) {
        return this.simpleFolderMatch(stack) != -1;
    }

    public boolean canInsertMob(EntityLivingBase elb, boolean doThing) {
        if (elb instanceof EntityPlayer) {
            return false;
        }
        if (!elb.func_184222_aU() || elb.func_70631_g_()) {
            return false;
        }
        if (elb instanceof EntityCabinet) {
            return false;
        }
        if (elb instanceof IEntityOwnable && ((IEntityOwnable)elb).func_70902_q() != null) {
            return false;
        }
        String entityblacklist = elb.getClass().getSimpleName();
        for (String toBlacklist : NewConfigRFC.ConfigRFC.mobFolderBlacklist) {
            if (!toBlacklist.contains(entityblacklist)) continue;
            return false;
        }
        String entityName = EntityList.func_191301_a((Entity)elb).toString();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack folder = this.getStackInSlot(i);
            if (folder == null || folder.func_77973_b() != RFCItems.folder || folder.func_77952_i() != 3 || ItemFolder.getObject(folder) == null || !ItemFolder.getObject(folder).equals(entityName)) continue;
            if (doThing) {
                ItemFolder.add(folder, 1L);
            }
            return true;
        }
        return false;
    }

    public int simpleFolderMatch(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack loopinv = this.getStackFromFolder(i);
            if (!loopinv.func_190926_b() && this.getStackInSlot(i).func_77952_i() == 2 && stack.func_77973_b() == loopinv.func_77973_b()) {
                if (stack.func_77942_o() && NBTUtils.getBoolean(this.getStackInSlot(i), StringLibs.RFC_IGNORENBT, false)) {
                    return i;
                }
                if (!stack.func_77942_o()) {
                    return i;
                }
            }
            if (!loopinv.func_190926_b() && this.getStackInSlot(i).func_77952_i() == 5 && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)loopinv)) {
                return i;
            }
            if (loopinv.func_190926_b() || this.getStackInSlot(i).func_77952_i() == 5 || this.getStackInSlot(i).func_77952_i() == 2 || !StorageUtils.simpleMatch(stack, loopinv)) continue;
            return i;
        }
        return -1;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }
}

