/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.integration;

import com.bafomdad.realfilingcabinet.api.IFilingCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileManaCabinet;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.MobUpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.TextHelper;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import com.google.common.base.Function;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TopRFC {
    public static void register() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.bafomdad.realfilingcabinet.integration.TopRFC$GetTheOneProbe");
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "realfilingcabinet:default";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
                    if (state.func_177230_c() instanceof IFilingCabinet) {
                        TileEntity tile = world.func_175625_s(data.getPos());
                        if (tile instanceof TileEntityRFC) {
                            TileEntityRFC tileRFC = (TileEntityRFC)tile;
                            for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
                                this.addFolderInfo(info, tileRFC, i);
                            }
                            if (player.func_70093_af()) {
                                this.addExtraInfo(info, tileRFC);
                            }
                            if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_SMELT) != null) {
                                info.progress(tileRFC.fuelTime, 1600);
                            }
                        } else if (tile instanceof TileManaCabinet) {
                            TileManaCabinet tileMana = (TileManaCabinet)tile;
                            this.addManaInfo(info, tileMana);
                        }
                    }
                }
            });
            probe.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return "realfilingcabinet:entity";
                }

                public void addProbeEntityInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                    EntityCabinet cabinet;
                    if (entity instanceof EntityCabinet && (cabinet = (EntityCabinet)entity) != null) {
                        this.addCabinetInfo(info, cabinet);
                        if (player.func_70093_af()) {
                            this.addMobUpgradeInfo(info, cabinet);
                        }
                    }
                }
            });
            return null;
        }

        public void addFolderInfo(IProbeInfo info, TileEntityRFC tile, int slot) {
            String name;
            ItemStack folder = tile.getInventory().getTrueStackInSlot(slot);
            if (!folder.func_190926_b() && (name = TextHelper.folderStr(folder)) != null) {
                long storedSize = ItemFolder.getFileSize(folder);
                if (folder.func_77973_b() == RFCItems.folder && folder.func_77952_i() == ItemFolder.FolderType.DURA.ordinal()) {
                    int storedRem = ItemFolder.getRemSize(folder);
                    int maxDamage = ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getItemStack().func_77958_k();
                    name = name + " - " + storedSize + " [" + storedRem + " / " + maxDamage + "]";
                }
                if (folder.func_77973_b() == RFCItems.folder && folder.func_77952_i() == ItemFolder.FolderType.FLUID.ordinal()) {
                    name = name + " - " + storedSize + "mB";
                } else if (folder.func_77973_b() == RFCItems.dyedFolder || folder.func_77973_b() == RFCItems.folder && folder.func_77952_i() != ItemFolder.FolderType.FLUID.ordinal() && folder.func_77952_i() != ItemFolder.FolderType.DURA.ordinal()) {
                    name = name + " - " + storedSize;
                }
                info.horizontal().text(name);
            }
        }

        public void addExtraInfo(IProbeInfo info, TileEntityRFC tile) {
            this.addLockInfo(info, tile);
            this.addUpgradeInfo(info, tile);
        }

        public void addUpgradeInfo(IProbeInfo info, TileEntityRFC tile) {
            String upgrade = "Upgrade: ";
            if (!UpgradeHelper.hasUpgrade(tile)) {
                info.horizontal().text(TextFormatting.GRAY + upgrade + "NONE");
            } else {
                info.horizontal().text(TextFormatting.GRAY + upgrade + TextFormatting.GREEN + UpgradeHelper.getUpgrade(tile, tile.upgrades));
            }
            if (UpgradeHelper.isCreative(tile)) {
                info.horizontal().text(TextFormatting.DARK_PURPLE + "Creative Upgrade");
            }
        }

        public void addLockInfo(IProbeInfo info, TileEntityRFC tile) {
            boolean locked = tile.isCabinetLocked();
            String lockFormat = "";
            lockFormat = locked ? TextFormatting.RED + "Yes" : TextFormatting.RESET + "No";
            info.horizontal().text(TextFormatting.GRAY + "Locked: " + lockFormat);
        }

        public void addManaInfo(IProbeInfo info, TileManaCabinet tile) {
            double count = tile.getTotalInternalManaPool();
            double calc = 0.0;
            if (count > 0.0) {
                calc = count / 1000000.0;
            }
            NumberFormat percentFormatter = NumberFormat.getPercentInstance();
            String percentOut = percentFormatter.format(calc);
            String name = percentOut + " of a full mana pool";
            info.horizontal().text(name);
        }

        public void addCabinetInfo(IProbeInfo info, EntityCabinet cabinet) {
            info.horizontal().text("Currently carrying:");
            for (int i = 0; i < cabinet.getInventory().getSlots(); ++i) {
                long storedSize;
                String name;
                ItemStack folder = cabinet.getInventory().getStackInSlot(i);
                if (folder == null || folder.func_77973_b() != RFCItems.folder) continue;
                if (ItemFolder.getObject(folder) != null && ItemFolder.getObject(folder) instanceof ItemStack) {
                    name = ((ItemStack)ItemFolder.getObject(folder)).func_82833_r();
                    storedSize = ItemFolder.getFileSize(folder);
                    info.horizontal().text(name + " - " + storedSize);
                }
                if (ItemFolder.getObject(folder) != null && ItemFolder.getObject(folder) instanceof FluidStack) {
                    name = ((FluidStack)ItemFolder.getObject(folder)).getLocalizedName();
                    storedSize = ItemFolder.getFileSize(folder);
                    info.horizontal().text(name + " - " + storedSize);
                }
                if (ItemFolder.getObject(folder) == null || !(ItemFolder.getObject(folder) instanceof String)) continue;
                String mobName = (String)ItemFolder.getObject(folder);
                storedSize = ItemFolder.getFileSize(folder);
                info.horizontal().text(mobName + " - " + storedSize);
            }
        }

        public void addMobUpgradeInfo(IProbeInfo info, EntityCabinet cabinet) {
            String upgrade = "Upgrade: ";
            if (!MobUpgradeHelper.hasMobUpgrade(cabinet)) {
                info.horizontal().text(TextFormatting.GRAY + upgrade + "NONE");
            } else {
                info.horizontal().text(TextFormatting.GRAY + upgrade + TextFormatting.GREEN + MobUpgradeHelper.getMobUpgrade(cabinet, cabinet.upgrades));
            }
        }
    }
}

