/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class TextHelper {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return TextHelper.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + TextHelper.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String localize(String str) {
        return net.minecraft.client.resources.I18n.func_135052_a((String)str, (Object[])new Object[0]);
    }

    public static String localizeCommands(String str) {
        return I18n.func_74837_a((String)("commands.realfilingcabinet." + str), (Object[])new Object[0]);
    }

    public static String folderStr(ItemStack folder) {
        if (!(folder.func_77973_b() instanceof IFolder)) {
            return null;
        }
        Object obj = ItemFolder.getObject(folder);
        if (obj != null) {
            return ((CapabilityFolder)folder.getCapability(CapabilityProviderFolder.FOLDER_CAP, null)).getDisplayName();
        }
        return null;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "b");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "q");
    }
}

