/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class ResourceUpgradeHelper {
    private static final Map<ResourceLocation, String> upgradeTextures = new HashMap<ResourceLocation, String>();
    private static final Map<ResourceLocation, String> upgradeMobTextures = new HashMap<ResourceLocation, String>();
    private static final ResourceLocation MOB_DEFAULT = new ResourceLocation("realfilingcabinet", "textures/entity/cabinettexture.png");
    private static final ResourceLocation DEFAULT = new ResourceLocation("realfilingcabinet", "textures/model/filingcabinet.png");
    private static final ResourceLocation HALLOWEEN = new ResourceLocation("realfilingcabinet", "textures/model/pumpkincabinet.png");
    private static final ResourceLocation CHRISTMAS = new ResourceLocation("realfilingcabinet", "textures/model/candycanecabinet.png");
    public static final ResourceLocation SMELTING = new ResourceLocation("realfilingcabinet", "textures/model/litfurnacecabinet.png");

    public static void registerUpgradeResource(ResourceLocation resource, String str) {
        if (resource == null || str.isEmpty()) {
            throw new IllegalArgumentException("[RealFilingCabinet]: Register upgrade resource: ResourceLocation is null, or the string tag is empty");
        }
        upgradeTextures.put(resource, str);
    }

    public static void registerMobUpgradeResource(ResourceLocation resource, String str) {
        if (resource == null || str.isEmpty()) {
            throw new IllegalArgumentException("[RealFilingCabinet]: Register upgrade mob resource: ResourceLocation is null, or the string tag is empty");
        }
        upgradeMobTextures.put(resource, str);
    }

    public static ResourceLocation getTexture(TileEntityRFC tile, String tag) {
        if (tag != null) {
            for (Map.Entry<ResourceLocation, String> entry : upgradeTextures.entrySet()) {
                String value = entry.getValue();
                if (!value.equals(tag)) continue;
                return entry.getKey();
            }
        }
        return DEFAULT;
    }

    public static ResourceLocation getMobTexture(EntityCabinet cabinet, String tag) {
        if (tag != null) {
            for (Map.Entry<ResourceLocation, String> entry : upgradeMobTextures.entrySet()) {
                String value = entry.getValue();
                if (!value.equals(tag)) continue;
                return entry.getKey();
            }
        }
        return MOB_DEFAULT;
    }

    public static ResourceLocation getDefault() {
        if (NewConfigRFC.ConfigRFC.seasonalCabinets) {
            LocalDateTime current = LocalDateTime.now();
            if (current.getMonth() == Month.OCTOBER) {
                return HALLOWEEN;
            }
            if (current.getMonth() == Month.DECEMBER) {
                return CHRISTMAS;
            }
        }
        return DEFAULT;
    }

    public static ResourceLocation getMobDefault() {
        return MOB_DEFAULT;
    }
}

