/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.api.ILockableCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemManaFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.botania.api.mana.IManaReceiver", modid="botania"), @Optional.Interface(iface="vazkii.botania.api.mana.spark.ISparkAttachable", modid="botania")})
public class TileManaCabinet
extends TileFilingCabinet
implements ITickable,
ILockableCabinet,
IManaReceiver,
ISparkAttachable {
    private ItemStackHandler inv = new ItemStackHandler(8);
    private UUID owner;
    public static final float offsetSpeed = 0.1f;
    public boolean isOpen = false;
    long MAX_MANA_INTERNAL = ItemManaFolder.getMaxManaFolder() * 8;

    public void func_73660_a() {
        if (this.isOpen) {
            this.offset -= 0.1f;
            if (this.offset <= -0.75f) {
                this.offset = -0.75f;
            }
        } else {
            this.offset += 0.1f;
            if (this.offset >= 0.05f) {
                this.offset = 0.05f;
            }
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeCustomNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74782_a("inventory", (NBTBase)this.getInv().serializeNBT());
        tag.func_74757_a("isOpen", this.isOpen);
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.getInv().deserializeNBT(tag.func_74775_l("inventory"));
        this.isOpen = tag.func_74767_n("isOpen");
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
    }

    public void readInv(NBTTagCompound nbt) {
        NBTTagList invList = nbt.func_150295_c("inventory", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = invList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.getInv().getSlots()) continue;
            this.getInv().setStackInSlot((int)slot, new ItemStack(itemTag));
        }
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            if (this.getInv().getStackInSlot(i) == ItemStack.field_190927_a) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.getInv().getStackInSlot(i).func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nonnull EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, @Nonnull EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getInv());
        }
        return (T)super.getCapability(cap, side);
    }

    @Override
    public UUID getCabinetOwner() {
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public boolean isCabinetLocked() {
        return this.getCabinetOwner() != null;
    }

    public boolean hasKeyCopy(EntityPlayer player, UUID uuid) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack keyCopy = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (keyCopy.func_190926_b() || keyCopy.func_77973_b() != RFCItems.keys || keyCopy.func_77952_i() != 1 || !keyCopy.func_77942_o() || !keyCopy.func_77978_p().func_74764_b(StringLibs.RFC_COPY)) continue;
            return uuid.equals(UUID.fromString(NBTUtils.getString(keyCopy, StringLibs.RFC_COPY, "")));
        }
        return false;
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public long getTotalInternalManaPool() {
        long total = 0L;
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            ItemStack stack = this.getInv().getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem)) continue;
            total += (long)ItemManaFolder.getManaSize(stack);
        }
        return total;
    }

    public int getManaFromFolder() {
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            int manaSize;
            ItemStack stack = this.getInv().getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || (manaSize = ItemManaFolder.getManaSize(stack)) < 0) continue;
            return manaSize;
        }
        return -1;
    }

    public void addManaToFolder(int mana) {
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            ItemStack stack = this.getInv().getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || mana > 0 && ItemManaFolder.isManaFolderFull(stack) || mana < 0 && ItemManaFolder.getManaSize(stack) <= 0) continue;
            ItemManaFolder.addManaToFolder(stack, mana);
            break;
        }
    }

    public boolean canRecieveManaFromBursts() {
        return this.getManaFromFolder() != -1;
    }

    public boolean isFull() {
        return this.getTotalInternalManaPool() == this.MAX_MANA_INTERNAL || this.getManaFromFolder() == -1;
    }

    public void recieveMana(int mana) {
        int manaToAdd = Math.min(ItemManaFolder.getMaxManaFolder(), mana);
        this.addManaToFolder(manaToAdd);
    }

    public int getCurrentMana() {
        return this.getManaFromFolder();
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity arg0) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        if (this.getTotalInternalManaPool() == this.MAX_MANA_INTERNAL) {
            return 0;
        }
        return 1000;
    }
}

