/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.api.ILockableCabinet;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.integration.storagedrawers.CabinetData;
import com.bafomdad.realfilingcabinet.inventory.FluidRFC;
import com.bafomdad.realfilingcabinet.inventory.InventoryRFC;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;

@Optional.Interface(iface="com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup", modid="storageDrawers", striprefs=true)
public class TileEntityRFC
extends TileFilingCabinet
implements ITickable,
ILockableCabinet,
IDrawerGroup {
    private InventoryRFC inv = new InventoryRFC(this, 8);
    private FluidRFC fluidinv = new FluidRFC(this);
    private UUID owner;
    private long lastClickTime;
    private UUID lastClickUUID;
    private int rfcHash = -1;
    public boolean isCreative = false;
    public String upgrades = "";
    public List<int[]> smeltingJobs = Lists.newArrayList();
    public int fuelTime = 0;
    public ItemStack uncraftableItem = ItemStack.field_190927_a;
    public static final float offsetSpeed = 0.1f;
    public boolean isOpen = false;
    @CapabilityInject(value=IDrawerGroup.class)
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;

    public void func_73660_a() {
        if (this.isOpen) {
            this.offset -= 0.1f;
            if (this.offset <= -0.75f) {
                this.offset = -0.75f;
            }
        } else {
            this.offset += 0.1f;
            if (this.offset >= 0.05f) {
                this.offset = 0.05f;
            }
        }
        if (SmeltingUtils.canSmelt(this)) {
            SmeltingUtils.incrementSmeltTime(this);
            if (this.func_145831_w().func_82737_E() % 40L == 0L) {
                SmeltingUtils.createSmeltingJob(this);
                this.markBlockForUpdate();
            }
            return;
        }
        if (UpgradeHelper.getUpgrade(this, StringLibs.TAG_LIFE) != null) {
            if (!this.field_145850_b.field_72995_K) {
                EntityCabinet cabinet = new EntityCabinet(this.field_145850_b);
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                float angle = ((EnumFacing)state.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_185119_l();
                cabinet.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5);
                cabinet.func_70034_d(angle);
                for (int i = 0; i < this.getInventory().getSlots(); ++i) {
                    ItemStack folder = this.getInventory().getTrueStackInSlot(i);
                    if (folder == null) continue;
                    cabinet.setInventory(i, folder.func_77946_l());
                }
                if (this.isCabinetLocked()) {
                    UUID uuid = this.getCabinetOwner();
                    cabinet.func_184754_b(uuid);
                } else {
                    cabinet.homePos = this.func_174877_v().func_177986_g();
                }
                if (!cabinet.isLegit()) {
                    cabinet.setLegit();
                }
                this.field_145850_b.func_72838_d((Entity)cabinet);
            }
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeCustomNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        tag.func_74757_a("isOpen", this.isOpen);
        tag.func_74757_a(StringLibs.TAG_CREATIVE, this.isCreative);
        tag.func_74782_a(StringLibs.RFC_CRAFTABLE, (NBTBase)this.uncraftableItem.serializeNBT());
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
        if (this.rfcHash != -1) {
            tag.func_74768_a(StringLibs.RFC_HASH, this.rfcHash);
        }
        tag.func_74778_a(StringLibs.RFC_UPGRADE, this.upgrades);
        SmeltingUtils.writeSmeltNBT(this, tag);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.inv.deserializeNBT(tag.func_74775_l("inventory"));
        this.isOpen = tag.func_74767_n("isOpen");
        this.isCreative = tag.func_74767_n(StringLibs.TAG_CREATIVE);
        if (tag.func_74764_b(StringLibs.RFC_CRAFTABLE)) {
            this.uncraftableItem = new ItemStack((NBTTagCompound)tag.func_74781_a(StringLibs.RFC_CRAFTABLE));
        }
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        if (tag.func_74764_b(StringLibs.RFC_HASH)) {
            this.rfcHash = tag.func_74762_e(StringLibs.RFC_HASH);
        }
        this.upgrades = tag.func_74779_i(StringLibs.RFC_UPGRADE);
        SmeltingUtils.readSmeltNBT(this, tag);
    }

    public void readInv(NBTTagCompound nbt) {
        NBTTagList invList = nbt.func_150295_c("inventory", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = invList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.getSlots()) continue;
            this.inv.getStacks().set((int)slot, (Object)new ItemStack(itemTag));
        }
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            if (this.inv.getTrueStackInSlot(i).func_190926_b()) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.inv.getTrueStackInSlot(i).func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    public InventoryRFC getInventory() {
        return this.inv;
    }

    public IFluidHandler getFluidInventory() {
        return this.fluidinv;
    }

    public boolean calcLastClick(EntityPlayer player) {
        boolean bool = false;
        if (this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID)) {
            bool = true;
        }
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return bool;
    }

    public boolean hasItemFrame() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
        List frames = this.func_145831_w().func_72872_a(EntityItemFrame.class, aabb);
        Iterator iterator = frames.iterator();
        if (iterator.hasNext()) {
            EntityItemFrame frame = (EntityItemFrame)iterator.next();
            EnumFacing orientation = frame.func_184172_bi();
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            EnumFacing rfcOrientation = (EnumFacing)state.func_177229_b((IProperty)BlockRFC.FACING);
            return frame != null && orientation == rfcOrientation;
        }
        return false;
    }

    public ItemStack getFilter() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
        List frames = this.func_145831_w().func_72872_a(EntityItemFrame.class, aabb);
        for (EntityItemFrame frame : frames) {
            EnumFacing orientation = frame.func_184172_bi();
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            EnumFacing rfcOrientation = (EnumFacing)state.func_177229_b((IProperty)BlockRFC.FACING);
            if (frame == null || frame.func_82335_i().func_190926_b() || orientation != rfcOrientation) continue;
            if (frame.func_82335_i().func_77973_b() == RFCItems.filter) {
                int rotation = frame.func_82333_j();
                return this.inv.getStackFromFolder(rotation);
            }
            return frame.func_82335_i();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && UpgradeHelper.getUpgrade(this, StringLibs.TAG_FLUID) != null) {
            return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }
        if (cap == DRAWER_GROUP_CAPABILITY && !UpgradeHelper.hasUpgrade(this)) {
            return cap == DRAWER_GROUP_CAPABILITY;
        }
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidinv);
        }
        if (cap == DRAWER_GROUP_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(cap, side);
    }

    @Override
    public UUID getCabinetOwner() {
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public boolean isCabinetLocked() {
        return this.getCabinetOwner() != null;
    }

    public boolean hasKeyCopy(EntityPlayer player, UUID uuid) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack keyCopy = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (keyCopy.func_190926_b() || keyCopy.func_77973_b() != RFCItems.keys || keyCopy.func_77952_i() != 1 || !keyCopy.func_77942_o() || !keyCopy.func_77978_p().func_74764_b(StringLibs.RFC_COPY)) continue;
            return uuid.equals(UUID.fromString(NBTUtils.getString(keyCopy, StringLibs.RFC_COPY, "")));
        }
        return false;
    }

    public void setHash(TileEntity tile) {
        this.rfcHash = EnderUtils.createHash(this);
    }

    public int getHash(TileEntityRFC tile) {
        return this.rfcHash;
    }

    public int getDrawerCount() {
        return this.inv.getSlots();
    }

    @Optional.Method(modid="storageDrawers")
    public IDrawer getDrawer(int slot) {
        return new CabinetData(this, slot);
    }

    public int[] getAccessibleDrawerSlots() {
        return new int[this.inv.getSlots()];
    }
}

