/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.blocks.BlockAC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemAspectFolder;
import com.bafomdad.realfilingcabinet.utils.AspectStorageUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aspects.IEssentiaTransport;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.aspects.IAspectSource", modid="thaumcraft"), @Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="thaumcraft")})
public class TileEntityAC
extends TileFilingCabinet
implements ITickable,
IAspectSource,
IEssentiaTransport {
    private ItemStackHandler inv = new ItemStackHandler(8);
    public static final float offsetSpeed = 0.1f;
    public boolean isOpen = false;

    public void func_73660_a() {
        if (this.isOpen) {
            this.offset -= 0.1f;
            if (this.offset <= -0.75f) {
                this.offset = -0.75f;
            }
        } else {
            this.offset += 0.1f;
            if (this.offset >= 0.05f) {
                this.offset = 0.05f;
            }
        }
    }

    public ItemStack getFilter() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
        List frames = this.func_145831_w().func_72872_a(EntityItemFrame.class, aabb);
        for (EntityItemFrame frame : frames) {
            EnumFacing orientation = frame.func_184172_bi();
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            EnumFacing rfcOrientation = (EnumFacing)state.func_177229_b((IProperty)BlockAC.FACING);
            if (frame == null || frame.func_82335_i().func_190926_b() || orientation != rfcOrientation) continue;
            if (frame.func_82335_i().func_77973_b() == RFCItems.filter) {
                int rotation = frame.func_82333_j();
                return this.inv.getStackInSlot(rotation);
            }
            if (!(frame.func_82335_i().func_77973_b() instanceof IEssentiaContainerItem)) continue;
            return frame.func_82335_i();
        }
        return ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeCustomNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74782_a("inventory", (NBTBase)this.getInv().serializeNBT());
        tag.func_74757_a("isOpen", this.isOpen);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.getInv().deserializeNBT(tag.func_74775_l("inventory"));
        this.isOpen = tag.func_74767_n("isOpen");
    }

    public void readInv(NBTTagCompound nbt) {
        NBTTagList invList = nbt.func_150295_c("inventory", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = invList.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.getInv().getSlots()) continue;
            this.getInv().setStackInSlot((int)slot, new ItemStack(itemTag));
        }
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            if (this.getInv().getStackInSlot(i).func_190926_b()) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.getInv().getStackInSlot(i).func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public boolean isBlocked() {
        return false;
    }

    public ItemStack getAspectFolder(Aspect tag) {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            Aspect asp;
            ItemStack folder = this.inv.getStackInSlot(i);
            if (folder.func_190926_b() || !(folder.func_77973_b() instanceof ItemAspectFolder) || (asp = ItemAspectFolder.getAspectFromFolder(folder)) != tag) continue;
            return folder;
        }
        return ItemStack.field_190927_a;
    }

    public int addToContainer(Aspect tag, int amount) {
        if (amount == 0) {
            return amount;
        }
        int internalCount = this.containerContains(tag);
        if (internalCount < ItemAspectFolder.getMaxAmount() || internalCount == 0) {
            int added = Math.max(amount, internalCount - ItemAspectFolder.getMaxAmount());
            ItemAspectFolder.addAspect(this.getAspectFolder(tag), added);
            amount -= added;
        }
        this.func_70296_d();
        return amount;
    }

    public int containerContains(Aspect tag) {
        if (!this.getAspectFolder(tag).func_190926_b()) {
            return ItemAspectFolder.getAspectCount(this.getAspectFolder(tag));
        }
        return -1;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return !this.getAspectFolder(tag).func_190926_b();
    }

    @Deprecated
    public boolean doesContainerContain(AspectList aspects) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        ItemStack folder = this.getAspectFolder(tag);
        if (folder.func_190926_b()) {
            return false;
        }
        int internalCount = ItemAspectFolder.getAspectCount(folder);
        Aspect internalAsp = ItemAspectFolder.getAspectFromFolder(folder);
        return internalCount >= amount && tag == internalAsp;
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            ItemStack folder = this.inv.getStackInSlot(i);
            if (folder.func_190926_b() || !(folder.func_77973_b() instanceof ItemAspectFolder)) continue;
            Aspect asp = ItemAspectFolder.getAspectFromFolder(folder);
            int amount = ItemAspectFolder.getAspectCount(folder);
            al.add(asp, amount);
        }
        return al;
    }

    public void setAspects(AspectList aspects) {
        Aspect asp;
        ItemStack folder;
        if (aspects != null && aspects.size() > 0 && !(folder = this.getAspectFolder(asp = aspects.getAspectsSortedByAmount()[0])).func_190926_b()) {
            ItemAspectFolder.setAspect(folder, asp);
            ItemAspectFolder.setAspectCount(folder, aspects.getAmount(asp));
        }
    }

    @Deprecated
    public boolean takeFromContainer(AspectList aspects) {
        return false;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.doesContainerContainAmount(tag, amount)) {
            ItemStack folder = this.getAspectFolder(tag);
            ItemAspectFolder.removeAspect(folder, amount);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isConnectable(EnumFacing facing) {
        return facing != EnumFacing.DOWN;
    }

    public boolean canInputFrom(EnumFacing facing) {
        return facing != EnumFacing.DOWN;
    }

    public boolean canOutputTo(EnumFacing facing) {
        return facing == EnumFacing.DOWN;
    }

    public void setSuction(Aspect asp, int amount) {
    }

    public Aspect getSuctionType(EnumFacing facing) {
        return AspectStorageUtils.getFirstAspectStored(this, this.getFilter()).getAspects()[0];
    }

    public int getSuctionAmount(EnumFacing facing) {
        return 64;
    }

    public int takeEssentia(Aspect asp, int amount, EnumFacing facing) {
        return this.canOutputTo(facing) && this.takeFromContainer(asp, amount) ? amount : 0;
    }

    public int addEssentia(Aspect asp, int amount, EnumFacing facing) {
        return this.canInputFrom(facing) ? amount - this.addToContainer(asp, amount) : 0;
    }

    public Aspect getEssentiaType(EnumFacing facing) {
        return this.getSuctionType(facing);
    }

    public int getEssentiaAmount(EnumFacing facing) {
        return AspectStorageUtils.getFirstAspectStored(this, this.getFilter()).getAmount(this.getSuctionType(facing));
    }

    public int getMinimumSuction() {
        return 32;
    }
}

