/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.IFilingCabinet;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.api.IUpgrades;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.items.ItemKeys;
import com.bafomdad.realfilingcabinet.items.ItemUpgrades;
import com.bafomdad.realfilingcabinet.utils.AutocraftingUtils;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.FluidUtils;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Optional.Interface(iface="com.jaquadro.minecraft.storagedrawers.api.storage.INetworked", modid="storageDrawers", striprefs=true)
public class BlockRFC
extends Block
implements IFilingCabinet,
INetworked {
    static float f = 0.0625f;
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0 + (double)f, 0.0, 0.0 + (double)f, 1.0 - (double)f, 1.0 - (double)f, 1.0 - (double)f);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockRFC() {
        super(Material.field_151573_f);
        this.setRegistryName("modelcabinet");
        this.func_149663_c("realfilingcabinet.filingcabinet");
        this.func_149711_c(5.0f);
        this.func_149752_b(1000.0f);
        this.func_149647_a(TabRFC.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean wat) {
        BlockRFC.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, collidingBoxes, (AxisAlignedBB)BASE_AABB);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityRFC tileRFC = (TileEntityRFC)world.func_175625_s(pos);
        if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_MOB) == null) {
            return;
        }
        if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer) {
            return;
        }
        EntityLivingBase elb = (EntityLivingBase)entity;
        if (!elb.func_184222_aU() || elb.func_70631_g_() && !(elb instanceof EntityZombie)) {
            return;
        }
        for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
            ItemStack folder = tileRFC.getInventory().getTrueStackInSlot(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder) continue;
            Object obj = ItemFolder.getObject(folder);
            if (folder.func_77952_i() != 3 || obj == null || !obj.equals(entity.getClass())) continue;
            MobUtils.dropMobEquips(world, elb);
            elb.func_70106_y();
            ItemFolder.add(folder, 1L);
            break;
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && tile instanceof TileEntityRFC) {
            this.leftClick(tile, player);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityRFC) {
                this.rightClick(tile, player, facing, hitX, hitY, hitZ);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityRFC && stack.func_77942_o()) {
            ((TileEntityRFC)tile).readInv(stack.func_77978_p());
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184607_cu());
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ItemStack upgrade;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRFC && !(upgrade = UpgradeHelper.stackTest((TileEntityRFC)tile)).func_190926_b() && upgrade.func_77952_i() != ItemUpgrades.UpgradeType.LIFE.ordinal()) {
            if (upgrade.func_190916_E() == 0) {
                upgrade.func_190920_e(1);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)upgrade);
        }
        super.func_180663_b(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack s = new ItemStack((Block)this);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityRFC)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        ((TileEntityRFC)tile).writeInv(tag, true);
        if (!tag.func_82582_d()) {
            s.func_77982_d(tag);
        }
        drops.add((Object)s);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRFC();
    }

    @Override
    public void leftClick(TileEntity tile, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileEntityRFC tileRFC = (TileEntityRFC)tile;
        if (tileRFC.isCabinetLocked() && !tileRFC.getCabinetOwner().equals(player.func_110124_au()) && !tileRFC.hasKeyCopy(player, tileRFC.getCabinetOwner())) {
            return;
        }
        if (player.func_70093_af() && !player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == RFCItems.magnifyingGlass) {
            if (!tileRFC.func_145831_w().field_72995_K) {
                UpgradeHelper.removeUpgrade(player, tileRFC);
            }
            tileRFC.markBlockForUpdate();
            return;
        }
        if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_CRAFT) == null) {
            StorageUtils.extractStackManually(tileRFC, player, player.func_70093_af());
            return;
        }
        ItemStack toCraft = tileRFC.getFilter().func_77946_l();
        if (!tileRFC.getFilter().func_190926_b() && toCraft.func_77951_h()) {
            toCraft.func_77964_b(0);
        }
        if (AutocraftingUtils.canCraft(tileRFC.getFilter(), tileRFC)) {
            ItemStack stack = toCraft;
            stack.func_190920_e(AutocraftingUtils.getOutputSize());
            if (!UpgradeHelper.isCreative(tileRFC)) {
                AutocraftingUtils.doCraft(tileRFC.getFilter(), (IItemHandler)tileRFC.getInventory());
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
    }

    @Override
    public void rightClick(TileEntity tile, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityRFC tileRFC = (TileEntityRFC)tile;
        ItemStack stack = player.func_184614_ca();
        if (tileRFC.isCabinetLocked() && !tileRFC.getCabinetOwner().equals(player.func_110124_au()) && !tileRFC.hasKeyCopy(player, tileRFC.getCabinetOwner())) {
            return;
        }
        if (tileRFC.calcLastClick(player)) {
            StorageUtils.addAllStacksManually(tileRFC, player);
        }
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemKeys) {
                if (!tileRFC.isCabinetLocked()) {
                    if (stack.func_77952_i() == 0) {
                        tileRFC.setOwner(player.func_110124_au());
                    }
                } else {
                    if (tileRFC.getCabinetOwner().equals(player.func_110124_au()) && stack.func_77952_i() == 0) {
                        tileRFC.setOwner(null);
                        return;
                    }
                    if (tileRFC.getCabinetOwner().equals(player.func_110124_au()) && stack.func_77952_i() == 1 && (!stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b(StringLibs.RFC_COPY))) {
                        NBTUtils.setString(stack, StringLibs.RFC_COPY, player.func_110124_au().toString());
                        NBTUtils.setString(stack, StringLibs.RFC_FALLBACK, player.getDisplayNameString());
                    }
                }
                return;
            }
            if (stack.func_77973_b() instanceof IFolder && tileRFC.isOpen) {
                if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_ENDER) != null) {
                    if (stack.func_77952_i() == 1) {
                        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                    return;
                }
                if (stack.func_77952_i() == 4 && UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_FLUID) != null) {
                    for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
                        ItemStack tileStack = tileRFC.getInventory().getTrueStackInSlot(i);
                        if (!tileStack.func_190926_b()) continue;
                        tileRFC.getInventory().setStackInSlot(i, stack);
                        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        tileRFC.markBlockForUpdate();
                        break;
                    }
                    return;
                }
                if (stack.func_77952_i() != 1 && !tileRFC.func_145831_w().field_72995_K) {
                    if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_FLUID) != null && !FluidUtils.canAcceptFluidContainer(stack)) {
                        return;
                    }
                    for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
                        ItemStack tileStack = tileRFC.getInventory().getTrueStackInSlot(i);
                        if (!tileStack.func_190926_b()) continue;
                        tileRFC.getInventory().setStackInSlot(i, stack);
                        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        tileRFC.markBlockForUpdate();
                        break;
                    }
                }
                return;
            }
            if (stack.func_77973_b() instanceof IUpgrades) {
                if (!tileRFC.func_145831_w().field_72995_K) {
                    UpgradeHelper.setUpgrade(player, tileRFC, stack);
                }
                tileRFC.markBlockForUpdate();
                return;
            }
            StorageUtils.addStackManually(tileRFC, player, stack);
            return;
        }
        if (!player.func_70093_af() && stack.func_190926_b()) {
            if (!tileRFC.func_145831_w().field_72995_K) {
                tileRFC.isOpen = !tileRFC.isOpen;
                tileRFC.func_70296_d();
            }
            tileRFC.markBlockForUpdate();
        }
        if (player.func_70093_af() && stack.func_190926_b() && tileRFC.isOpen) {
            if (UpgradeHelper.getUpgrade(tileRFC, StringLibs.TAG_ENDER) != null) {
                EnderUtils.extractEnderFolder(tileRFC, player);
                return;
            }
            StorageUtils.folderExtract(tileRFC, player, side, hitX, hitY, hitZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityRFC tileRFC = (TileEntityRFC)world.func_175625_s(pos);
        if (tileRFC != null && tileRFC.isCabinetLocked() && !tileRFC.getCabinetOwner().equals(player.func_110124_au())) {
            return -1.0f;
        }
        return ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityRFC)) {
            return;
        }
        if (SmeltingUtils.isSmelting((TileEntityRFC)tile)) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

