/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.api.IFilingCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileManaCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.integration.BotaniaRFC;
import com.bafomdad.realfilingcabinet.items.ItemKeys;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockManaCabinet
extends Block
implements IFilingCabinet {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockManaCabinet() {
        super(Material.field_151576_e);
        this.setRegistryName("manacabinet");
        this.func_149663_c("realfilingcabinet.manacabinet");
        this.func_149711_c(5.0f);
        this.func_149752_b(1000.0f);
        this.func_149647_a(TabRFC.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side.func_176745_a() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof TileManaCabinet) {
                this.rightClick(tile, player, facing, hitX, hitY, hitZ);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileManaCabinet && stack.func_77942_o()) {
            ((TileManaCabinet)tile).readInv(stack.func_77978_p());
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184607_cu());
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack s = new ItemStack((Block)this);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileManaCabinet)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        ((TileManaCabinet)tile).writeInv(tag, true);
        if (!tag.func_82582_d()) {
            s.func_77982_d(tag);
            drops.add((Object)s);
            return;
        }
    }

    @Override
    public void leftClick(TileEntity tile, EntityPlayer player) {
    }

    @Override
    public void rightClick(TileEntity tile, EntityPlayer player, EnumFacing side, float hitX, float hity, float hitZ) {
        TileManaCabinet tileMana = (TileManaCabinet)tile;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (tileMana.isCabinetLocked() && !tileMana.getCabinetOwner().equals(player.func_110124_au()) && !tileMana.hasKeyCopy(player, tileMana.getCabinetOwner())) {
            return;
        }
        if (!player.func_70093_af() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemKeys) {
                if (!tileMana.isCabinetLocked()) {
                    if (stack.func_77952_i() == 0) {
                        tileMana.setOwner(player.func_110124_au());
                    }
                } else {
                    if (tileMana.getCabinetOwner().equals(player.func_110124_au()) && stack.func_77952_i() == 0) {
                        tileMana.setOwner(null);
                        return;
                    }
                    if (tileMana.getCabinetOwner().equals(player.func_110124_au()) && stack.func_77952_i() == 1 && (!stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b(StringLibs.RFC_COPY))) {
                        NBTUtils.setString(stack, StringLibs.RFC_COPY, player.func_110124_au().toString());
                        NBTUtils.setString(stack, StringLibs.RFC_FALLBACK, player.getDisplayNameString());
                    }
                }
                return;
            }
            if (stack.func_77973_b() == BotaniaRFC.manaFolder && tileMana.isOpen) {
                for (int i = 0; i < tileMana.getInv().getSlots(); ++i) {
                    ItemStack tileStack = tileMana.getInv().getStackInSlot(i);
                    if (!tileStack.func_190926_b()) continue;
                    tileMana.getInv().setStackInSlot(i, stack);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    tileMana.markBlockForRenderUpdate();
                    break;
                }
                return;
            }
        }
        if (!player.func_70093_af() && stack.func_190926_b()) {
            if (!tileMana.func_145831_w().field_72995_K) {
                tileMana.isOpen = !tileMana.isOpen;
                tileMana.func_70296_d();
            }
            tileMana.markBlockForUpdate();
        }
        if (player.func_70093_af() && stack.func_190926_b() && tileMana.isOpen) {
            for (int i = tileMana.getInv().getSlots() - 1; i >= 0; --i) {
                ItemStack folder = tileMana.getInv().getStackInSlot(i);
                if (folder.func_190926_b()) continue;
                tileMana.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                player.func_184611_a(EnumHand.MAIN_HAND, folder);
                tileMana.markBlockForUpdate();
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileManaCabinet tileMana = (TileManaCabinet)world.func_175625_s(pos);
        if (tileMana != null && tileMana.isCabinetLocked() && !tileMana.getCabinetOwner().equals(player.func_110124_au())) {
            return -1.0f;
        }
        return ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileManaCabinet();
    }
}

