/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class NewConfigRFC {
    public static HashMap<String, Boolean> boolean_stuff = new HashMap();

    public static void preInit(FMLPreInitializationEvent event) {
        NewConfigRFC.checkTappedValues(ConfigRFC.class);
    }

    public static void checkTappedValues(Class clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            Tap tapped = f.getAnnotation(Tap.class);
            if (tapped != null) {
                try {
                    Map map;
                    Field tapField;
                    Class c = tapped.mapClass();
                    if (c == null || (tapField = c.getDeclaredField(tapped.mapName())) == null || (map = (Map)tapField.get(null)) == null) continue;
                    map.put(f.getName(), f.get(null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (f.getType().getSuperclass() != Object.class) continue;
            NewConfigRFC.checkTappedValues(f.getType());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tap {
        public Class mapClass() default NewConfigRFC.class;

        public String mapName() default "boolean_stuff";
    }

    @Config(modid="realfilingcabinet")
    public static class ConfigRFC {
        @Config.Comment(value={"Enable Crafting Upgrade recipe"})
        @Tap
        public static boolean craftingUpgrade = true;
        @Config.Comment(value={"Enable Ender Upgrade recipe"})
        @Tap
        public static boolean enderUpgrade = true;
        @Config.Comment(value={"Enable Oredict Upgrade recipe"})
        @Tap
        public static boolean oreDictUpgrade = true;
        @Config.Comment(value={"Enable Mob Upgrade recipe"})
        @Tap
        public static boolean mobUpgrade = true;
        @Config.Comment(value={"Enable Fluid Upgrade recipe"})
        @Tap
        public static boolean fluidUpgrade = true;
        @Config.Comment(value={"Enable Life Upgrade recipe"})
        @Tap
        public static boolean lifeUpgrade = true;
        @Config.Comment(value={"Enable Smelting Upgrade recipe"})
        @Tap
        public static boolean smeltingUpgrade = true;
        @Config.Comment(value={"Disable this if you want TheOneProbe to handle the overlay instead."})
        @Tap
        public static boolean magnifyingGlassGui = true;
        @Config.Comment(value={"If enabled, will let Mob Folders with a villager in it spawn villagers with their professions randomized."})
        @Tap
        public static boolean randomVillager = false;
        @Config.Comment(value={"If enabled, will let filing cabinets use a different texture depending on the season."})
        @Tap
        public static boolean seasonalCabinets = true;
        @Config.Comment(value={"If enabled, will let Fluid Folders place water in the nether."})
        @Tap
        public static boolean waterNether = false;
        @Config.Comment(value={"If disabled, will not let folders pick up dropped items."})
        @Tap
        public static boolean pickupStuff = true;
        @Config.Comment(value={"Will output stuff to console for debugging purposes."})
        @Tap
        public static boolean debugLogger = false;
        @Config.Comment(value={"Use this to blacklist certain mobs from being captured in the Mob Folder. Put the class names of the entities here."})
        public static String[] mobFolderBlacklist = new String[0];
        @Config.Comment(value={"If enabled, A fluid cabinet filled with more than 3000mb of water will never run out of water."})
        @Tap
        public static boolean infiniteWaterSource = true;
        @Config.Comment(value={"Configure the general folder storage limit for dyed folders."})
        @Tap
        public static int folderSizeLimit = 1000;
        @Config.Comment(value={"If enabled, will add mana cabinets and folders for Botania"})
        @Tap
        public static boolean botaniaIntegration = true;
        @Config.Comment(value={"If enabled, will add a folder and a cabinet when it detects that Thaumcraft is installed."})
        @Tap
        public static boolean tcIntegration = true;
    }
}

