/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.blocks;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.blocks.PowercellNetwork;
import mcjty.rftoolspower.blocks.Tier;
import mcjty.rftoolspower.config.Config;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public abstract class PowerCellTileEntity
extends GenericTileEntity
implements ITickable,
IBigPower {
    private PowercellNetwork network = null;
    private long localEnergy = 0L;
    private Mode[] modes = new Mode[]{Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE, Mode.MODE_NONE};
    private int outputCount = 0;
    private static Set<BlockPos> alreadyReportedBad = new HashSet<BlockPos>();
    private static Set<BlockPos> alreadyReportedUnexpected = new HashSet<BlockPos>();
    private IEnergyStorage[] sidedHandlers = new IEnergyStorage[6];
    private IEnergyStorage nullHandler;

    public Mode getMode(EnumFacing side) {
        return this.modes[side.ordinal()];
    }

    public void toggleMode(EnumFacing side) {
        switch (this.modes[side.ordinal()]) {
            case MODE_NONE: {
                this.modes[side.ordinal()] = Mode.MODE_INPUT;
                break;
            }
            case MODE_INPUT: {
                this.modes[side.ordinal()] = Mode.MODE_OUTPUT;
                break;
            }
            case MODE_OUTPUT: {
                this.modes[side.ordinal()] = Mode.MODE_NONE;
            }
        }
        this.updateOutputCount();
        this.markDirtyClient();
    }

    private void updateOutputCount() {
        this.outputCount = 0;
        for (Mode mode : this.modes) {
            if (mode != Mode.MODE_OUTPUT) continue;
            ++this.outputCount;
        }
    }

    abstract Tier getTier();

    abstract long getLocalMaxEnergy();

    abstract long getRfPerTickPerSide();

    public long getRfPerTickReal() {
        if (Config.RFPERTICK_SCALE > 0.0f) {
            return (long)((float)this.getRfPerTickPerSide() + (float)((long)(this.getNetwork().getPositions().size() - 1) * this.getRfPerTickPerSide()) * Config.RFPERTICK_SCALE);
        }
        return this.getRfPerTickPerSide();
    }

    public long getStoredPower() {
        return this.getNetwork().getEnergy();
    }

    public long getCapacity() {
        return this.getNetwork().getMaxEnergy();
    }

    private long receiveEnergyFacing(EnumFacing from, long maxReceive, boolean simulate) {
        if (this.modes[from.ordinal()] != Mode.MODE_INPUT) {
            return 0L;
        }
        PowercellNetwork network = this.getNetwork();
        if (network == null || !network.isValid()) {
            return 0L;
        }
        long received = this.receiveEnergyLocal(maxReceive = Math.min(maxReceive, this.getRfPerTickReal()), simulate);
        if (received > 0L) {
            if (!simulate) {
                network.addEnergy(received);
            }
            maxReceive -= received;
        }
        long totReceived = received;
        if (maxReceive > 0L) {
            for (Long l : network.getPositions()) {
                PowerCellTileEntity powercell;
                BlockPos p = BlockPos.func_177969_a((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (!(te instanceof PowerCellTileEntity) || (received = (powercell = (PowerCellTileEntity)te).receiveEnergyLocal(maxReceive, simulate)) <= 0L) continue;
                if (!simulate) {
                    network.addEnergy(received);
                }
                maxReceive -= received;
                totReceived += received;
            }
        }
        return totReceived;
    }

    private long receiveEnergyLocal(long maxReceive, boolean simulate) {
        long maxInsert = Math.min(this.getLocalMaxEnergy() - this.localEnergy, maxReceive);
        if (maxInsert > 0L && !simulate) {
            this.localEnergy += maxInsert;
            this.markDirtyQuick();
        }
        return maxInsert;
    }

    private int getEnergyStoredAsInt() {
        return (int)Math.min(Integer.MAX_VALUE, this.getNetwork().getEnergy());
    }

    private int getMaxEnergyStoredAsInt() {
        return (int)Math.min(Integer.MAX_VALUE, this.getNetwork().getMaxEnergy());
    }

    public void func_73660_a() {
        PowercellNetwork network;
        if (!this.field_145850_b.field_72995_K && this.outputCount > 0 && (network = this.getNetwork()) != null && network.isValid()) {
            long energyStored = network.getEnergy();
            if (energyStored <= 0L) {
                return;
            }
            this.sendOutEnergy(energyStored);
        }
    }

    public void redistributeNetwork() {
        PowercellNetwork network = this.getNetwork();
        if (network == null || network.getPositions().isEmpty()) {
            return;
        }
        long[] energy = new long[]{0L, 0L, 0L};
        int[] count = new int[]{0, 0, 0};
        network.getPositions().stream().forEach(l -> {
            BlockPos p = BlockPos.func_177969_a((long)l);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te instanceof PowerCellTileEntity) {
                int t;
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                int n = t = powercell.getTier().ordinal();
                energy[n] = energy[n] + powercell.getLocalEnergy();
                int n2 = t;
                count[n2] = count[n2] + 1;
            }
        });
        for (Tier tier : Tier.values()) {
            if (count[tier.ordinal()] <= 0) continue;
            long energyPerBlock = energy[tier.ordinal()] / (long)count[tier.ordinal()];
            long[] energyToSet = new long[]{energyPerBlock + energy[tier.ordinal()] % (long)count[tier.ordinal()]};
            network.getPositions().stream().forEach(l -> {
                PowerCellTileEntity powercell;
                BlockPos p = BlockPos.func_177969_a((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (te instanceof PowerCellTileEntity && (powercell = (PowerCellTileEntity)te).getTier() == tier) {
                    powercell.setLocalEnergy(energyToSet[0]);
                    powercell.markDirtyQuick();
                    energyToSet[0] = energyPerBlock;
                }
            });
        }
    }

    private void validateNetwork() {
        long[] energy = new long[]{0L};
        long[] maxEnergy = new long[]{0L};
        this.getNetwork().getPositions().stream().forEach(l -> {
            BlockPos p = BlockPos.func_177969_a((long)l);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te instanceof PowerCellTileEntity) {
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                energy[0] = energy[0] + powercell.getLocalEnergy();
                maxEnergy[0] = maxEnergy[0] + powercell.getLocalMaxEnergy();
                if (powercell.network != this.network) {
                    System.out.println("##### Network doesn't match at: " + p);
                }
            } else {
                System.out.println("##### Not a powercell: " + p);
            }
        });
        if (this.network.getEnergy() != energy[0]) {
            System.out.println("##### Energy mismatch! Got " + energy[0] + ", expected " + this.network.getEnergy());
        }
        if (this.network.getMaxEnergy() != maxEnergy[0]) {
            System.out.println("##### Max energy mismatch! Got " + maxEnergy[0] + ", expected " + this.network.getMaxEnergy());
        }
    }

    private void sendOutEnergy(long energyStored) {
        long energyExtracted = 0L;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            EnumFacing opposite;
            if (this.modes[face.ordinal()] != Mode.MODE_OUTPUT) continue;
            BlockPos pos = this.func_174877_v().func_177972_a(face);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (!EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)(opposite = face.func_176734_d())) && (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, opposite)) || te instanceof PowerCellTileEntity) continue;
            long rfPerTick = this.getRfPerTickReal();
            long rfToGive = Math.min(rfPerTick, energyStored);
            long received = EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)rfToGive);
            energyExtracted += received;
            if ((energyStored -= received) <= 0L) break;
        }
        if (energyExtracted > 0L) {
            this.network.extractEnergy(energyExtracted);
            this.extractEnergyFromNetwork(energyExtracted);
        }
    }

    private void extractEnergyFromNetwork(long energyExtracted) {
        long toExtractLocal = Math.min(energyExtracted, this.localEnergy);
        if (toExtractLocal > 0L) {
            this.localEnergy -= toExtractLocal;
            energyExtracted -= toExtractLocal;
            this.markDirtyQuick();
        }
        if (energyExtracted > 0L) {
            for (Long l : this.network.getPositions()) {
                BlockPos p = BlockPos.func_177969_a((long)l);
                TileEntity te = this.field_145850_b.func_175625_s(p);
                if (!(te instanceof PowerCellTileEntity)) continue;
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                toExtractLocal = Math.min(energyExtracted, powercell.localEnergy);
                if (toExtractLocal > 0L) {
                    powercell.localEnergy -= toExtractLocal;
                    energyExtracted -= toExtractLocal;
                    powercell.markDirtyQuick();
                }
                if (energyExtracted > 0L) continue;
                break;
            }
        }
    }

    public long getLocalEnergy() {
        return this.localEnergy;
    }

    public void setLocalEnergy(long localEnergy) {
        this.localEnergy = localEnergy;
    }

    public PowercellNetwork getNetwork() {
        if (this.network == null) {
            this.buildNetwork(new PowercellNetwork(), this.field_174879_c);
        }
        return this.network;
    }

    public void setNetwork(PowercellNetwork network) {
        this.network = network;
    }

    public void dismantleNetwork(PowercellNetwork network) {
        network.getPositions().stream().map(BlockPos::func_177969_a).forEach(pos -> {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te instanceof PowerCellTileEntity) {
                PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                powercell.setNetwork(null);
            }
        });
    }

    private void buildNetwork(PowercellNetwork network, BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            if (network.contains(pos)) {
                if (powercell.network != network && !alreadyReportedBad.contains(pos)) {
                    System.out.println("Bad network at pos = " + pos + " (dimension " + this.field_145850_b.field_73011_w.getDimension() + ")");
                    alreadyReportedBad.add(pos);
                }
                return;
            }
            if (powercell.network == network) {
                if (!alreadyReportedUnexpected.contains(pos)) {
                    System.out.println("Unexpected network at pos = " + pos + " (dimension " + this.field_145850_b.field_73011_w.getDimension() + ")");
                    alreadyReportedUnexpected.add(pos);
                }
                return;
            }
            if (powercell.network != null) {
                this.dismantleNetwork(powercell.network);
            }
            powercell.setNetwork(network);
            network.add(pos);
            network.setEnergy(network.getEnergy() + powercell.getLocalEnergy());
            network.setMaxEnergy(network.getMaxEnergy() + powercell.getLocalMaxEnergy());
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.buildNetwork(network, pos.func_177972_a(facing));
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        Mode[] old = new Mode[]{this.modes[0], this.modes[1], this.modes[2], this.modes[3], this.modes[4], this.modes[5]};
        super.onDataPacket(net, packet);
        for (int i = 0; i < 6; ++i) {
            if (old[i] == this.modes[i]) continue;
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.modes[0] = Mode.values()[tagCompound.func_74771_c("m0")];
        this.modes[1] = Mode.values()[tagCompound.func_74771_c("m1")];
        this.modes[2] = Mode.values()[tagCompound.func_74771_c("m2")];
        this.modes[3] = Mode.values()[tagCompound.func_74771_c("m3")];
        this.modes[4] = Mode.values()[tagCompound.func_74771_c("m4")];
        this.modes[5] = Mode.values()[tagCompound.func_74771_c("m5")];
        this.updateOutputCount();
        this.localEnergy = tagCompound.func_74763_f("local");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74774_a("m0", (byte)this.modes[0].ordinal());
        tagCompound.func_74774_a("m1", (byte)this.modes[1].ordinal());
        tagCompound.func_74774_a("m2", (byte)this.modes[2].ordinal());
        tagCompound.func_74774_a("m3", (byte)this.modes[3].ordinal());
        tagCompound.func_74774_a("m4", (byte)this.modes[4].ordinal());
        tagCompound.func_74774_a("m5", (byte)this.modes[5].ordinal());
        tagCompound.func_74772_a("local", this.localEnergy);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_HOLDER || capability == EnergyTools.TESLA_CONSUMER && facing != null) {
            if (facing == null) {
                if (this.nullHandler == null) {
                    this.createNullHandler();
                }
                return (T)this.nullHandler;
            }
            if (this.sidedHandlers[facing.ordinal()] == null) {
                this.createSidedHandler(facing);
            }
            return (T)this.sidedHandlers[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }

    private void createSidedHandler(final EnumFacing facing) {
        @Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
        class SidedHandler
        implements IEnergyStorage,
        ITeslaConsumer,
        ITeslaHolder {
            SidedHandler() {
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)PowerCellTileEntity.this.receiveEnergyFacing(facing, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return PowerCellTileEntity.this.getEnergyStoredAsInt();
            }

            public int getMaxEnergyStored() {
                return PowerCellTileEntity.this.getMaxEnergyStoredAsInt();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }

            @Optional.Method(modid="tesla")
            public long getStoredPower() {
                return PowerCellTileEntity.this.getStoredPower();
            }

            @Optional.Method(modid="tesla")
            public long getCapacity() {
                return PowerCellTileEntity.this.getCapacity();
            }

            @Optional.Method(modid="tesla")
            public long givePower(long power, boolean simulated) {
                return PowerCellTileEntity.this.receiveEnergyFacing(facing, power, simulated);
            }
        }
        this.sidedHandlers[facing.ordinal()] = new SidedHandler();
    }

    private void createNullHandler() {
        @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")
        class NullHandler
        implements IEnergyStorage,
        ITeslaHolder {
            NullHandler() {
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return PowerCellTileEntity.this.getEnergyStoredAsInt();
            }

            public int getMaxEnergyStored() {
                return PowerCellTileEntity.this.getMaxEnergyStoredAsInt();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return false;
            }

            @Optional.Method(modid="tesla")
            public long getStoredPower() {
                return PowerCellTileEntity.this.getStoredPower();
            }

            @Optional.Method(modid="tesla")
            public long getCapacity() {
                return PowerCellTileEntity.this.getCapacity();
            }
        }
        this.nullHandler = new NullHandler();
    }

    public static enum Mode implements IStringSerializable
    {
        MODE_NONE("none"),
        MODE_INPUT("input"),
        MODE_OUTPUT("output");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

