/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack.variant;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSize;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class BackpackVariant {
    @Nonnull
    private final BackpackType backpackType;
    @Nonnull
    private final BackpackSpecialty backpackSpecialty;
    @Nonnull
    private final BackpackSize backpackSize;
    @Nonnegative
    private final int maxUpgradePoints;
    @Nonnull
    private final ResourceLocation identifier;

    public BackpackVariant(@Nonnull BackpackType type, @Nonnull BackpackSpecialty backpackSpecialty) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null");
        Preconditions.checkNotNull((Object)((Object)backpackSpecialty), (Object)"Specialty cannot be null");
        this.backpackType = type;
        this.maxUpgradePoints = type.applyDefaultUpgradePointModifierFromBackpackSpecialty(backpackSpecialty);
        this.backpackSpecialty = backpackSpecialty;
        this.backpackSize = type.getBaseBackpackSize().applyDefaultSizeModifierFromBackpackSpecialty(backpackSpecialty);
        this.identifier = new ResourceLocation("ironbackpacks", "variant_" + type.getIdentifier().func_110623_a() + "_" + backpackSpecialty.func_176610_l());
    }

    @Nonnull
    public BackpackType getBackpackType() {
        return this.backpackType;
    }

    @Nonnull
    public BackpackSpecialty getBackpackSpecialty() {
        return this.backpackSpecialty;
    }

    @Nonnull
    public BackpackSize getBackpackSize() {
        return this.backpackSize;
    }

    @Nonnegative
    public int getMaxUpgradePoints() {
        return this.maxUpgradePoints;
    }

    @Nonnull
    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackpackVariant that = (BackpackVariant)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return "TYPE: " + (Object)((Object)this.backpackType) + " --- SPECIALTY: " + (Object)((Object)this.backpackSpecialty) + " --- UPGRADE POINTS: " + this.maxUpgradePoints + " --- SIZE: " + this.backpackSize + " --- IDENTIFIER: " + this.identifier.toString();
    }
}

