/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

public class Waveform {
    public static final double EXTERNAL_SPEED = 20.0;
    public static final double SYNC_TOLERANCE = 0.1;
    public static final double MIN_COMM_SPEED = 4.0;
    public static final Waveform[] VALUES = new Waveform[Type.VALUES.length * Phases.VALUES.length * Speed.VALUES.length];
    private Type type;
    private Phases phases;
    private Speed speed;

    public static boolean isSyncSpeed(double speed) {
        return Math.abs(speed - 20.0) < 2.0;
    }

    public static Waveform forParameters(Type t, Phases p, Speed s) {
        return VALUES[Waveform.getIndex(t, p, s)];
    }

    private static int getIndex(Type t, Phases p, Speed s) {
        return t.ordinal() * Phases.VALUES.length * Speed.VALUES.length + p.ordinal() * Speed.VALUES.length + s.ordinal();
    }

    private Waveform(Type type, Phases phases, Speed speed) {
        this.type = type;
        this.phases = phases;
        this.speed = speed;
    }

    public Waveform getCommutated(double speed, boolean fourPhase) {
        if (speed < 4.0) {
            return this;
        }
        Type commType = this.type;
        if (this.type == Type.AC) {
            commType = Type.DC;
        } else if (this.type == Type.DC) {
            commType = Type.AC;
        }
        Speed commSpeed = Speed.ROTATION;
        if (Waveform.isSyncSpeed(speed)) {
            commSpeed = Speed.EXTERNAL;
        } else if (this.type == Type.AC && this.speed == Speed.EXTERNAL) {
            commType = Type.MESS;
        }
        return Waveform.forParameters(commType, this.phases, commSpeed);
    }

    public boolean isAC() {
        return this.type == Type.AC;
    }

    public boolean isDC() {
        return this.type == Type.DC;
    }

    public boolean isEnergyWaveform() {
        return this.type != Type.NONE && this.type != Type.MESS;
    }

    public boolean isSinglePhase() {
        return this.phases == Phases.SINGLE;
    }

    public Waveform getForSpeed(double speed) {
        if (this.speed == Speed.ROTATION && Waveform.isSyncSpeed(speed)) {
            return Waveform.forParameters(this.type, this.phases, Speed.EXTERNAL);
        }
        return this;
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + (Object)((Object)this.phases) + ":" + (Object)((Object)this.speed);
    }

    public static Waveform fromString(String in) {
        String[] elements = in.split(":");
        try {
            Type t = Type.valueOf(elements[0]);
            Phases p = Phases.valueOf(elements[1]);
            Speed s = Speed.valueOf(elements[1]);
            return Waveform.forParameters(t, p, s);
        }
        catch (Exception x) {
            return Waveform.forParameters(Type.NONE, Phases.SINGLE, Speed.ROTATION);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waveform waveform = (Waveform)o;
        if (this.type != waveform.type) {
            return false;
        }
        if (this.phases != waveform.phases) {
            return false;
        }
        return this.type != Type.AC || this.speed == waveform.speed;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.phases.hashCode();
        return result;
    }

    static {
        for (Type t : Type.VALUES) {
            for (Phases p : Phases.VALUES) {
                for (Speed s : Speed.VALUES) {
                    Waveform.VALUES[Waveform.getIndex((Type)t, (Phases)p, (Speed)s)] = new Waveform(t, p, s);
                }
            }
        }
    }

    public static enum Speed {
        ROTATION,
        EXTERNAL;

        public static final Speed[] VALUES;

        static {
            VALUES = Speed.values();
        }
    }

    public static enum Phases {
        SINGLE,
        FOUR;

        public static final Phases[] VALUES;

        public static Phases get(boolean has4Phases) {
            return has4Phases ? FOUR : SINGLE;
        }

        static {
            VALUES = Phases.values();
        }
    }

    public static enum Type {
        NONE,
        MESS,
        AC,
        DC;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

