/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.crafting;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeKeyRing
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final boolean addToRing;

    public RecipeKeyRing(boolean add) {
        this.addToRing = add;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nullable World worldIn) {
        return this.isValid(inv);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        if (this.isValid(inv)) {
            NBTTagList keys;
            if (this.addToRing) {
                ItemStack ring = inv.func_70301_a(this.getRingPos(inv)).func_77946_l();
                NBTTagCompound nbt = ring.func_77978_p();
                ItemStack key = inv.func_70301_a(this.getKeyPos(inv));
                NBTTagCompound keyNBT = key.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                    ring.func_77982_d(nbt);
                }
                if (!nbt.func_74764_b("ringkeys")) {
                    nbt.func_74782_a("ringkeys", (NBTBase)new NBTTagList());
                }
                if (keyNBT != null) {
                    NBTTagList keys2 = nbt.func_150295_c("ringkeys", 10);
                    if (keys2.func_74745_c() >= IWConfig.maxKeysOnRing) {
                        return ItemStack.field_190927_a;
                    }
                    keys2.func_74742_a((NBTBase)keyNBT.func_74737_b());
                    nbt.func_74768_a("lockId", keyNBT.func_74762_e("lockId"));
                    nbt.func_74778_a("name", keyNBT.func_74779_i("name"));
                }
                return ring;
            }
            ItemStack ring = inv.func_70301_a(this.getRingPos(inv)).func_77946_l();
            NBTTagCompound nbt = ring.func_77978_p();
            ItemStack key = new ItemStack((Item)IndustrialWires.key, 1, 1);
            if (nbt != null && (keys = nbt.func_150295_c("ringkeys", 10)).func_74745_c() > 0) {
                NBTTagCompound first = keys.func_150305_b(keys.func_74745_c() - 1);
                key.func_77982_d(first);
                return key;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 0 && height > 0;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((Item)IndustrialWires.key, 1, this.addToRing ? 2 : 1);
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        int ringId;
        ItemStack ring;
        NBTTagCompound nbt;
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.addToRing && (nbt = (ring = inv.func_70301_a(ringId = this.getRingPos(inv)).func_77946_l()).func_77978_p()) != null) {
            NBTTagList keys = nbt.func_150295_c("ringkeys", 10);
            keys.func_74744_a(keys.func_74745_c() - 1);
            if (keys.func_74745_c() > 0) {
                NBTTagCompound first = keys.func_150305_b(0);
                keys.func_74744_a(0);
                keys.func_74742_a((NBTBase)first);
                nbt.func_74768_a("lockId", first.func_74762_e("lockId"));
                nbt.func_74778_a("name", first.func_74779_i("name"));
            } else {
                nbt.func_82580_o("lockId");
                nbt.func_82580_o("name");
            }
            ret.set(ringId, (Object)ring);
        }
        return ret;
    }

    private boolean isValid(@Nonnull InventoryCrafting inv) {
        boolean hasRing = false;
        boolean hasKey = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack here = inv.func_70301_a(i);
            if (here.func_77973_b() == IndustrialWires.key) {
                if (here.func_77960_j() == 1 && !hasKey) {
                    hasKey = true;
                    continue;
                }
                if (here.func_77960_j() == 2 && !hasRing) {
                    hasRing = true;
                    continue;
                }
                return false;
            }
            if (here.func_190926_b()) continue;
            return false;
        }
        if (this.addToRing) {
            return hasKey && hasRing;
        }
        return !hasKey && hasRing;
    }

    private int getRingPos(@Nonnull InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack here = inv.func_70301_a(i);
            if (here.func_77973_b() != IndustrialWires.key || here.func_77960_j() != 2) continue;
            return i;
        }
        return -1;
    }

    private int getKeyPos(@Nonnull InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack here = inv.func_70301_a(i);
            if (here.func_77973_b() != IndustrialWires.key || here.func_77960_j() != 1) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        if (this.addToRing) {
            NonNullList ret = NonNullList.func_191197_a((int)2, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)IndustrialWires.key, 1, 1)}));
            ret.set(1, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)IndustrialWires.key, 1, 2)}));
            return ret;
        }
        return NonNullList.func_191197_a((int)1, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)IndustrialWires.key, 1, 2)}));
    }
}

