/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.compat;

import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.hv.MarxOreHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialwires.MarxGenerator")
public class CTMarxGenerator {
    @ZenMethod
    public static void addRecipe(IIngredient in, double avgRelEnergy, double maxMain, IItemStack outMain, @Optional int smallLargeRatio, @Optional IItemStack outSmall) {
        Supplier<ItemStack> supSmall;
        Supplier<ItemStack> out = () -> CraftTweakerMC.getItemStack((IItemStack)outMain);
        Supplier<ItemStack> supplier = supSmall = outSmall != null ? () -> CraftTweakerMC.getItemStack((IItemStack)outSmall) : null;
        if (in instanceof IItemStack) {
            IBlock properIn = ((IItemStack)in).asBlock();
            if (properIn != null) {
                CraftTweakerAPI.apply((IAction)new Add(new MarxOreHandler.OreInfo((world, pos) -> CraftTweakerMC.getBlock((IBlockAccess)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p()).matches(properIn), (List<ItemStack>)ImmutableList.of((Object)CraftTweakerMC.getItemStack((IIngredient)in)), avgRelEnergy, maxMain, out, supSmall, smallLargeRatio)));
                return;
            }
        } else if (in instanceof IOreDictEntry) {
            String oreName = ((IOreDictEntry)in).getName();
            CraftTweakerAPI.apply((IAction)new Add(new MarxOreHandler.OreInfo(new MarxOreHandler.OreChecker(oreName), (List<ItemStack>)OreDictionary.getOres((String)oreName), avgRelEnergy, maxMain, out, supSmall, smallLargeRatio)));
            return;
        }
        throw new IllegalArgumentException("Invalid parameter " + in);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        if (input instanceof IItemStack) {
            CraftTweakerAPI.apply((IAction)new Remove(o -> input.matches(CraftTweakerMC.getIItemStack((ItemStack)o))));
            return;
        }
        if (input instanceof IOreDictEntry) {
            String oreName = ((IOreDictEntry)input).getName();
            int mainId = OreDictionary.getOreID((String)oreName);
            CraftTweakerAPI.apply((IAction)new Remove(i -> {
                int[] ids;
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)i)) {
                    if (id != mainId) continue;
                    return true;
                }
                return false;
            }));
            return;
        }
        throw new IllegalArgumentException("Invalid parameter " + input);
    }

    private static class Remove
    implements IAction {
        private final Predicate<ItemStack> inputMatcher;

        public Remove(Predicate<ItemStack> inputMatcher) {
            this.inputMatcher = inputMatcher;
        }

        public void apply() {
            Iterator<MarxOreHandler.OreInfo> ores = MarxOreHandler.getRecipes().iterator();
            block0: while (ores.hasNext()) {
                MarxOreHandler.OreInfo curr = ores.next();
                for (ItemStack input : curr.exampleInput) {
                    if (!this.inputMatcher.test(input)) continue;
                    ores.remove();
                    Compat.removeMarx.accept(curr);
                    continue block0;
                }
            }
        }

        public String describe() {
            return "Removing Marx Generator Recipes";
        }
    }

    private static class Add
    implements IAction {
        private final MarxOreHandler.OreInfo recipe;

        public Add(MarxOreHandler.OreInfo recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MarxOreHandler.put(this.recipe);
            Compat.addMarx.accept(this.recipe);
        }

        public String describe() {
            return "Adding Marx Generator Recipe for " + this.recipe.output.get();
        }
    }
}

