/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.wire;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IMixedConnector;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.util.MiscUtils;
import malte0811.industrialwires.wires.EnergyType;
import malte0811.industrialwires.wires.MixedWireType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")})
public class TileEntityIC2ConnectorTin
extends TileEntityImmersiveConnectable
implements IEnergySource,
IEnergySink,
IEBlockInterfaces.IDirectionalTile,
ITickable,
IMixedConnector,
IBlockBoundsIW {
    private static final double EPS = 0.1;
    private EnumFacing facing = EnumFacing.NORTH;
    private boolean relay;
    private double bufferToNet = 0.0;
    private double potentialIEInputInTick = 0.0;
    private double actualIEInputInTick = 0.0;
    private double maxToNet = 0.0;
    private double bufferToMachine = 0.0;
    private double externalInputInTick = 0.0;
    private double maxToMachine = 0.0;
    private EnergyType energyType = EnergyType.NONE;
    private boolean shouldBreak = false;
    private final double maxIO;
    private final MixedWireType wireType;
    private final int tier;
    private final double relayOffset;
    private final double connOffset;
    private EnergyHandler energyHandler = new EnergyHandler();

    protected TileEntityIC2ConnectorTin(boolean relay, MixedWireType type, int tier, double relayLength, double connLength) {
        this.relay = relay;
        this.wireType = type;
        this.maxIO = type.getIORate();
        this.tier = tier;
        this.relayOffset = relayLength - 0.5;
        this.connOffset = connLength - 0.5;
    }

    public TileEntityIC2ConnectorTin(boolean relay) {
        this(relay, MixedWireType.TIN, 1, 0.5, 0.5);
    }

    public TileEntityIC2ConnectorTin() {
        this(false);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K && IndustrialWires.hasIC2) {
            Compat.loadIC2Tile.accept((TileEntity)this);
        }
        ImmersiveNetHandler.INSTANCE.onTEValidated((TileEntity)this);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldBreak) {
                ArrayDeque<BlockPos> open = new ArrayDeque<BlockPos>();
                open.push(this.field_174879_c);
                HashSet<BlockPos> closed = new HashSet<BlockPos>();
                closed.add(this.field_174879_c);
                while (!open.isEmpty()) {
                    BlockPos next = (BlockPos)open.pop();
                    Set conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, next);
                    if (conns == null) continue;
                    for (ImmersiveNetHandler.Connection c : conns) {
                        ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).put(c, 2 * c.cableType.getTransferRate());
                        if (!closed.add(c.end)) continue;
                        open.push(c.end);
                    }
                }
                for (BlockPos p : closed) {
                    TileEntity tile = this.field_145850_b.func_175625_s(p);
                    if (!(tile instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tile).isEnergyOutput()) continue;
                    this.field_145850_b.func_72876_a(null, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, 3.0f, true);
                }
                return;
            }
            if (this.externalInputInTick == 0.0 && this.potentialIEInputInTick == 0.0 && this.bufferToNet == 0.0 && this.bufferToMachine == 0.0) {
                this.energyType = EnergyType.NONE;
            }
            if (this.bufferToNet < this.maxToNet) {
                this.maxToNet = this.bufferToNet;
            }
            if (this.externalInputInTick > this.maxToNet) {
                this.maxToNet = this.externalInputInTick;
            }
            this.externalInputInTick = 0.0;
            if (this.bufferToMachine < this.maxToMachine) {
                this.maxToMachine = this.bufferToMachine;
            }
            this.potentialIEInputInTick = Math.min(Math.max(this.potentialIEInputInTick, this.actualIEInputInTick), this.getMaxIO());
            if (this.potentialIEInputInTick > this.maxToMachine) {
                this.maxToMachine = this.potentialIEInputInTick;
            }
            this.potentialIEInputInTick = 0.0;
            this.actualIEInputInTick = 0.0;
            if (this.bufferToNet > 0.1) {
                this.transferPowerToNet();
            }
            if (this.bufferToNet > 0.1) {
                this.notifyAvailableEnergy(this.bufferToNet);
            }
            if (this.bufferToMachine > 0.1 && this.energyType == EnergyType.FE_AC) {
                this.transferPowerToFEMachine();
            }
        }
    }

    private void transferPowerToNet() {
        Set conns = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(this.field_174879_c, this.field_145850_b, true);
        HashMap<ImmersiveNetHandler.AbstractConnection, ImmutablePair> maxOutputs = new HashMap<ImmersiveNetHandler.AbstractConnection, ImmutablePair>();
        double outputMax = Math.min(this.bufferToNet, this.maxToNet);
        double sum = 0.0;
        for (ImmersiveNetHandler.AbstractConnection c : conns) {
            double extract;
            IImmersiveConnectable iic;
            if (!c.isEnergyOutput || !((iic = ApiUtils.toIIC((Object)c.end, (World)this.field_145850_b)) instanceof IMixedConnector) || !((extract = outputMax - ((IMixedConnector)iic).insertEnergy(outputMax, true, this.energyType)) > 0.1)) continue;
            maxOutputs.put(c, new ImmutablePair((Object)((IMixedConnector)iic), (Object)extract));
            sum += extract;
        }
        if (sum > 0.1) {
            HashMap transferedPerConn = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension());
            for (Map.Entry entry : maxOutputs.entrySet()) {
                Pair p = (Pair)entry.getValue();
                ImmersiveNetHandler.AbstractConnection c = (ImmersiveNetHandler.AbstractConnection)entry.getKey();
                double out = outputMax * (Double)p.getRight() / sum;
                double loss = this.energyType.getLoss(this.getAverageLossRate(c), this.bufferToNet, out);
                if ((out = Math.min(out, this.bufferToNet - loss)) <= 0.0) continue;
                double inserted = out - ((IMixedConnector)p.getLeft()).insertEnergy(out, false, this.energyType);
                double energyAtConn = inserted + loss;
                this.bufferToNet -= energyAtConn;
                float intermediaryLoss = 0.0f;
                HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
                for (ImmersiveNetHandler.Connection sub : c.subConnections) {
                    int transferredPerCon = transferedPerConn.getOrDefault(sub, 0);
                    double wireLoad = (energyAtConn -= sub.cableType.getLossRatio() * (double)sub.length) / (this.energyType == EnergyType.FE_AC ? IWConfig.wireRatio : 1.0);
                    transferedPerConn.put(sub, (int)((double)transferredPerCon + wireLoad));
                    IImmersiveConnectable subStart = ApiUtils.toIIC((Object)sub.start, (World)this.field_145850_b);
                    IImmersiveConnectable subEnd = ApiUtils.toIIC((Object)sub.end, (World)this.field_145850_b);
                    if (subStart != null && passedConnectors.add(subStart)) {
                        subStart.onEnergyPassthrough((int)(inserted - inserted * (double)intermediaryLoss));
                    }
                    if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                    subEnd.onEnergyPassthrough((int)(inserted - inserted * (double)intermediaryLoss));
                }
            }
        }
    }

    private void transferPowerToFEMachine() {
        BlockPos outPos = this.field_174879_c.func_177972_a(this.facing);
        TileEntity te = MiscUtils.getLoadedTE(this.field_145850_b, outPos, TileEntity.class);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) {
            IEnergyStorage handler = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d());
            assert (handler != null);
            double outJoules = Math.min(this.bufferToMachine, this.maxToMachine * IWConfig.wireRatio);
            int outFE = MathHelper.func_76128_c((double)(outJoules * ConversionUtil.ifPerJoule()));
            int received = handler.receiveEnergy(outFE, false);
            this.bufferToMachine -= (double)received * ConversionUtil.joulesPerIf();
        }
    }

    private void notifyAvailableEnergy(double storedNew) {
        Set outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(this.field_174879_c, this.field_145850_b, true);
        for (ImmersiveNetHandler.AbstractConnection con : outputs) {
            IImmersiveConnectable end = ApiUtils.toIIC((Object)con.end, (World)this.field_145850_b);
            if (con.cableType == null || end == null || !end.allowEnergyToPass(null)) continue;
            Pair<Float, Consumer<Float>> e = this.getEnergyForConnection(con, storedNew);
            end.addAvailableEnergy(((Float)e.getKey()).floatValue(), (Consumer)e.getValue());
        }
        this.addAvailableEnergy(-1.0f, null);
    }

    private Pair<Float, Consumer<Float>> getEnergyForConnection(@Nullable ImmersiveNetHandler.AbstractConnection c, double storedNew) {
        float loss = c != null ? c.getAverageLossRate() : 0.0f;
        float max = (float)(storedNew - (double)loss);
        Consumer<Float> extract = energy -> this.bufferToNet -= (double)(energy.floatValue() + loss);
        return new ImmutablePair((Object)Float.valueOf(max), extract);
    }

    private double getAverageLossRate(ImmersiveNetHandler.AbstractConnection conn) {
        double f = 0.0;
        for (ImmersiveNetHandler.Connection c : conn.subConnections) {
            WireType type = c.cableType;
            if (type instanceof MixedWireType) {
                f += (double)c.length * ((MixedWireType)type).getLoss(this.energyType);
                continue;
            }
            f = Double.POSITIVE_INFINITY;
        }
        return f;
    }

    @Override
    public double insertEnergy(double joules, boolean simulate, EnergyType type) {
        if (this.energyType == EnergyType.NONE) {
            this.energyType = type;
        } else if (this.energyType != type) {
            this.shouldBreak = true;
            return 0.0;
        }
        double insert = Math.min(this.getMaxIO() - this.bufferToMachine, joules);
        insert = Math.min(this.getMaxIO() - this.actualIEInputInTick, insert);
        if (!simulate) {
            this.bufferToMachine += insert;
            this.actualIEInputInTick += insert;
        } else {
            this.potentialIEInputInTick += Math.min(joules, this.getMaxIO());
        }
        return joules - insert;
    }

    private double getMaxIO() {
        return this.maxIO * (this.energyType == EnergyType.FE_AC ? IWConfig.wireRatio : 1.0);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            Compat.unloadIC2Tile.accept((TileEntity)this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            Compat.unloadIC2Tile.accept((TileEntity)this);
        }
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        double length = this.relay ? this.relayOffset : this.connOffset;
        return new Vec3d(0.5 + (length - conRadius) * (double)side.func_82601_c(), 0.5 + (length - conRadius) * (double)side.func_96559_d(), 0.5 + (length - conRadius) * (double)side.func_82599_e());
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return !this.relay;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return (this.limitType == null || this.isRelay()) && WireApi.canMix((WireType)cableType, (WireType)this.wireType);
    }

    protected boolean isRelay() {
        return this.relay;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return !this.relay && side == this.facing;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return !this.relay && side == this.facing;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        double ret = (this.getMaxIO() - this.bufferToNet) * ConversionUtil.euPerJoule() + 0.05;
        if (ret < 0.1) {
            ret = 0.0;
        }
        return ret;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.tier;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return amount - ConversionUtil.euPerJoule() * this.addToIn(ConversionUtil.joulesPerEu() * amount, false, EnergyType.EU_DC);
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        if (this.energyType != EnergyType.NONE && this.energyType != EnergyType.EU_DC) {
            return 0.01;
        }
        return Math.min(this.maxToMachine, this.bufferToMachine) * ConversionUtil.euPerJoule();
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        if (this.energyType != EnergyType.NONE && this.energyType != EnergyType.EU_DC) {
            this.shouldBreak = true;
        }
        this.bufferToMachine -= amount * ConversionUtil.joulesPerEu();
        this.func_70296_d();
    }

    @Nullable
    protected Pair<Float, Consumer<Float>> getOwnEnergy() {
        if (this.isRelay()) {
            return null;
        }
        return new ImmutablePair((Object)Float.valueOf((float)this.bufferToNet), d -> this.bufferToNet -= (double)d.floatValue());
    }

    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        return 0.015625f;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.tier;
    }

    private double addToIn(double joules, boolean simulate, EnergyType type) {
        if (this.energyType == EnergyType.NONE) {
            this.energyType = type;
        } else if (this.energyType != type) {
            this.shouldBreak = true;
        }
        joules = Math.min(this.getMaxIO() - this.externalInputInTick + 0.5, joules);
        if (this.bufferToNet < this.getMaxIO()) {
            if (!simulate) {
                this.bufferToNet += joules;
                this.externalInputInTick += joules;
                this.notifyAvailableEnergy(joules);
            }
            this.func_70296_d();
            return joules;
        }
        return 0.0;
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.relay = nbt.func_74767_n("relay");
        int version = nbt.func_74762_e("version");
        this.bufferToNet = nbt.func_74769_h("inBuffer");
        this.bufferToMachine = nbt.func_74769_h("outBuffer");
        this.maxToNet = nbt.func_74764_b("maxToNet") ? nbt.func_74769_h("maxToNet") : this.bufferToNet;
        this.maxToMachine = nbt.func_74764_b("maxToMachine") ? nbt.func_74769_h("maxToMachine") : this.bufferToMachine;
        this.energyType = EnergyType.values()[nbt.func_74762_e("energyType")];
        if (version == 0) {
            this.bufferToNet *= ConversionUtil.joulesPerEu();
            this.bufferToMachine *= ConversionUtil.joulesPerEu();
            this.maxToNet *= ConversionUtil.joulesPerEu();
            this.maxToMachine *= ConversionUtil.joulesPerEu();
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.func_176745_a());
        nbt.func_74757_a("relay", this.relay);
        nbt.func_74780_a("inBuffer", this.bufferToNet);
        nbt.func_74780_a("outBuffer", this.bufferToMachine);
        nbt.func_74780_a("maxToNet", this.maxToNet);
        nbt.func_74780_a("maxToMachine", this.maxToMachine);
        nbt.func_74768_a("energyType", this.energyType.ordinal());
        nbt.func_74768_a("version", 1);
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        double length = 0.5 + (this.relay ? this.relayOffset : this.connOffset);
        double wMin = 0.3125;
        double wMax = 0.6875;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new AxisAlignedBB(wMin, 0.0, wMin, wMax, length, wMax);
            }
            case DOWN: {
                return new AxisAlignedBB(wMin, 1.0 - length, wMin, wMax, 1.0, wMax);
            }
            case SOUTH: {
                return new AxisAlignedBB(wMin, wMin, 0.0, wMax, wMax, length);
            }
            case NORTH: {
                return new AxisAlignedBB(wMin, wMin, 1.0 - length, wMax, wMax, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, wMin, wMin, length, wMax, wMax);
            }
            case WEST: {
                return new AxisAlignedBB(1.0 - length, wMin, wMin, 1.0, wMax, wMax);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return !this.isRelay() && facing == this.facing;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (!this.isRelay() && facing == this.facing) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyHandler);
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int hashCode() {
        if (this.field_145850_b == null) {
            return 0;
        }
        int ret = this.field_145850_b.field_73011_w.getDimension();
        ret = 31 * ret + this.field_174879_c.hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TileEntityIC2ConnectorTin)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TileEntityIC2ConnectorTin te = (TileEntityIC2ConnectorTin)obj;
        if (!te.field_174879_c.equals((Object)this.field_174879_c)) {
            return false;
        }
        return te.field_145850_b.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension();
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }

    private class EnergyHandler
    implements IEnergyStorage {
        private EnergyHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (TileEntityIC2ConnectorTin.this.bufferToNet >= TileEntityIC2ConnectorTin.this.getMaxIO()) {
                return 0;
            }
            double joules = (double)maxReceive * ConversionUtil.joulesPerIf();
            double accepted = TileEntityIC2ConnectorTin.this.addToIn(joules, simulate, EnergyType.FE_AC);
            return MathHelper.func_76143_f((double)(accepted * ConversionUtil.ifPerJoule()));
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (TileEntityIC2ConnectorTin.this.energyType != EnergyType.FE_AC) {
                return 0;
            }
            double joules = (double)maxExtract * ConversionUtil.joulesPerIf();
            if (joules > TileEntityIC2ConnectorTin.this.maxToMachine) {
                joules = TileEntityIC2ConnectorTin.this.maxToMachine;
            }
            if (joules > TileEntityIC2ConnectorTin.this.bufferToMachine) {
                joules = TileEntityIC2ConnectorTin.this.bufferToMachine;
            }
            if (!simulate) {
                TileEntityIC2ConnectorTin.this.bufferToMachine = TileEntityIC2ConnectorTin.this.bufferToMachine - joules;
            }
            return MathHelper.func_76128_c((double)(ConversionUtil.ifPerJoule() * joules));
        }

        public int getEnergyStored() {
            return (int)((TileEntityIC2ConnectorTin.this.bufferToMachine + TileEntityIC2ConnectorTin.this.bufferToNet) * ConversionUtil.ifPerJoule());
        }

        public int getMaxEnergyStored() {
            return (int)(2.0 * TileEntityIC2ConnectorTin.this.getMaxIO() * ConversionUtil.ifPerJoule());
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

