/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.types;

import java.util.HashMap;
import java.util.Map;

public enum StructureType {
    STRUCTURE_NONE("None"),
    STRUCTURE_VILLAGE("Village"),
    STRUCTURE_STRONGHOLD("Stronghold"),
    STRUCTURE_DUNGEON("Dungeon"),
    STRUCTURE_FORTRESS("Fortress"),
    STRUCTURE_MINESHAFT("Mineshaft"),
    STRUCTURE_SCATTERED("Scattered"),
    STRUCTURE_OCEAN_MONUMENT("OceanMonument"),
    STRUCTURE_SWAMPHUT("SwampHut"),
    STRUCTURE_DESERTTEMPLE("DesertTemple"),
    STRUCTURE_JUNGLETEMPLE("JungleTemple"),
    STRUCTURE_IGLOO("Igloo");

    private static final Map<String, StructureType> STRUCTURE_TYPE_MAP;
    private final String id;

    private StructureType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static StructureType getStructureById(String id) {
        return STRUCTURE_TYPE_MAP.get(id);
    }

    static {
        STRUCTURE_TYPE_MAP = new HashMap<String, StructureType>();
        for (StructureType type : StructureType.values()) {
            STRUCTURE_TYPE_MAP.put(type.getId(), type);
        }
    }
}

