/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rustic.common.blocks.BlockLattice;
import rustic.common.blocks.BlockRopeBase;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.BlockGrapeLeaves;

public class BlockRope
extends BlockRopeBase {
    public BlockRope(String name) {
        super(Material.field_151580_n, name, true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.Y));
        Blocks.field_150480_ab.func_180686_a((Block)this, 20, 60);
    }

    @Override
    public boolean isSideSupported(World world, BlockPos pos, IBlockState state, EnumFacing facing) {
        IBlockState testState = world.func_180495_p(pos.func_177972_a(facing));
        if (facing == EnumFacing.DOWN) {
            return false;
        }
        boolean isSame = testState.func_177230_c() == state.func_177230_c() && (testState.func_177229_b((IProperty)AXIS) == state.func_177229_b((IProperty)AXIS) || state.func_177229_b((IProperty)AXIS) == EnumFacing.Axis.Y && facing.func_176740_k() == EnumFacing.Axis.Y);
        boolean isSideSolid = world.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), false);
        boolean isTiedStake = testState.func_177230_c() == ModBlocks.STAKE_TIED;
        boolean isGrapeLeaves = testState.func_177230_c() == ModBlocks.GRAPE_LEAVES && testState.func_177229_b(BlockGrapeLeaves.AXIS) == state.func_177229_b((IProperty)AXIS);
        boolean isLattice = testState.func_177230_c() instanceof BlockLattice;
        return isSame || isSideSolid || isTiedStake || isGrapeLeaves || isLattice;
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        IBlockState testState = world.func_180495_p(pos.func_177972_a(side.func_176734_d()));
        if (side == EnumFacing.UP) {
            return this.func_176198_a(world, pos, EnumFacing.DOWN);
        }
        boolean isThis = testState.func_177230_c() == this && testState.func_177229_b((IProperty)AXIS) == side.func_176740_k();
        boolean isSideSolid = world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, false);
        boolean isTiedStake = testState.func_177230_c() == ModBlocks.STAKE_TIED;
        boolean isGrapeLeaves = testState.func_177230_c() == ModBlocks.GRAPE_LEAVES && testState.func_177229_b(BlockGrapeLeaves.AXIS) == side.func_176740_k();
        boolean isLattice = testState.func_177230_c() instanceof BlockLattice;
        return isThis || isSideSolid || isTiedStake || isGrapeLeaves || isLattice;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityArrow && this.isArrowInAABB(worldIn, pos, state, (EntityArrow)entityIn)) {
            this.dropBlock(worldIn, pos, state);
        }
    }

    protected boolean isArrowInAABB(World worldIn, BlockPos pos, IBlockState state, EntityArrow entity) {
        double xExp = state.func_177229_b((IProperty)AXIS) == EnumFacing.Axis.X ? 0.0 : 0.125;
        double yExp = state.func_177229_b((IProperty)AXIS) == EnumFacing.Axis.Y ? 0.0 : 0.125;
        double zExp = state.func_177229_b((IProperty)AXIS) == EnumFacing.Axis.Z ? 0.0 : 0.125;
        AxisAlignedBB aabb = this.func_185496_a(state, (IBlockAccess)worldIn, pos);
        if (aabb != null) {
            aabb = aabb.func_72321_a(xExp, yExp, zExp).func_186670_a(pos);
            if (entity.func_174813_aQ() != null && aabb.func_72326_a(entity.func_174813_aQ())) {
                return true;
            }
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (state.func_177229_b((IProperty)AXIS) == side.func_176740_k()) {
            return BlockFaceShape.CENTER_SMALL;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

